package cn.com.startai.qxcommon.busi.qx;

import android.app.Application;
import android.net.NetworkInfo;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.ICommonBusi;
import cn.com.startai.qxcommon.busi.qx.bean.LoginReq;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateReq;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public interface IQxBusi extends ICommonBusi {


    /**
     * 初始化 会自动连接 服务器
     *
     * @param application
     * @param initParam
     * @param commonListener
     */
    void init(Application application, QXCommonInitParam initParam, AQXBusiListener commonListener);

    /**
     * 获取与服务器的连接状态
     */
    MqttConnectState getServerConnectState();

    /**
     * 获取当前网络类型
     */
    NetworkInfo.State getNetworkState();

    /**
     * 获取当前网络连接状态
     *
     * @return
     */
    String getNetworkType();

    /**
     * 获取当前登录的用户，如果没有登录会返回null
     *
     * @return
     */
    UserBean getUserBean();

    /**
     * 登录当前用户
     */
    void logout();

    /**
     * 激活 主要是用于给无法联网的智能硬件激活
     */
    void activate(ActivateReq req, ICallListener callListener);

    /**
     * 登录
     *
     * @param req
     * @param callListener
     */
    void login(LoginReq req, ICallListener callListener);

}
