package cn.com.startai.qxcommon.busi.huadian;

import android.app.Application;

import com.google.gson.JsonObject;

import org.json.JSONException;
import org.json.JSONObject;

import cn.com.startai.common.channel.CErrorCode;
import cn.com.startai.common.channel.CallbackManager;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDInitReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdReq;
import cn.com.startai.qxcommon.busi.qx.QxBusi;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.protocol.QXBaseContentImpl;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.QXErrorCode;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public class HDTrainer extends QxBusi implements IHDTrainerBusi, IDeveloper.MsgTw, HDCmd {


    private HDTrainer() {
    }

    public static HDTrainer getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final HDTrainer singleTonInstance = new HDTrainer();
    }

    private boolean hasCallbackInit;

    public boolean isHasCallbackInit() {
        return hasCallbackInit;
    }

    public void setHasCallbackInit(boolean hasCallbackInit) {
        this.hasCallbackInit = hasCallbackInit;
    }

    private AHDTrainerListener hdListener;

    /**
     * 初始化后不会自动连接服务器
     *
     * @param app
     * @param listener
     */
    @Override
    public void init(Application app, AHDTrainerListener listener) {
        this.hdListener = listener;
        this.application = app;
    }

    @Override
    public void release() {
        this.hdListener = null;
        this.application = null;
        this.commonListener = null;
        this.qxBusiListener = null;
        super.release();
    }


    @Override
    public synchronized void doSend(final String data) {

        if (application == null) {
            CLog.e(TAG, "please call init first");
            return;
        }
        if (data == null) {
            CLog.e(TAG, "data == null");
            return;
        }

        final QXMessage<QXBaseContentImpl> qxMessageBean = QXJsonUtils.fromJsonToQXMessage(data, QXBaseContentImpl.class);
        if (qxMessageBean == null || qxMessageBean.getContent() == null) {
            CLog.e(TAG, "error msg : " + data);
            if (hdListener != null) {
                hdListener.onSendFailed(data, CErrorCode.ERROR_SEND_PARAM_INVALIBLE);
            }
            return;
        }


        long cmd = qxMessageBean.getContent().getCmd();
        int msgtw = qxMessageBean.getMsgtw();


        switch (msgtw) {

            case TW_APP_SET:
            case TW_APP_QUERY:
            case TW_APP_REPORT:
            case TW_APP_ALARM:
            case TW_APP_PASSTHROUGH:

                if (cmd == SDK_INIT) {

                    QXMessage<HDInitReq> initReq = QXJsonUtils.fromJsonToQXMessage(data, HDInitReq.class);
                    QXMessageConverter.getInstance().onReceive(initReq);
                    init(application, new QXCommonInitParam.Builder().appid(initReq.getContent().getAppid()).build(), hdListener);

                    if (QXSpController.getInstance().getIsActivite()) {
                        if (hdListener != null && !hasCallbackInit) {
                            hdListener.onInitSuccess(ParamManager.getInstance().getDeveloperParam());
                            hasCallbackInit = true;
                        }
                    }
                } else if (cmd == SDK_RELEASE) {

                    release();
                } else if (cmd == SDK_LOGOUT) {

                    QXMessageConverter.getInstance().onReceive(qxMessageBean);
                    logout();
                } else if (cmd == SDK_SERVER_CONNECT_STATE) {

                    QXMessageConverter.getInstance().onReceive(qxMessageBean);
                    if (hdListener != null) {
                        hdListener.callbackServerConnectState(getServerConnectState());
                    }
                } else if (cmd == SDK_NETWORK_STATE) {

                    QXMessageConverter.getInstance().onReceive(qxMessageBean);
                    if (hdListener != null) {
                        hdListener.callbackNetworkState(getNetworkType(), getNetworkState());
                    }
                } else {
                    CLog.e(TAG, "unsupport send cmd");
                    if (hdListener != null) {
                        hdListener.onSendFailed(data, QXErrorCode.ERROR_CMD);
                    }
                }
                break;
            case TW_APP_CLOUD_ALARM:
            case TW_APP_CLOUD_REPORT:
            case TW_APP_CLOUD_SET:
            case TW_APP_CLOUD_PASSTHROUGH:
            case TW_APP_CLOUD_QUERY:

            case TW_APP_CLOUD_THIRDCLOUD_ALARM:
            case TW_APP_CLOUD_THIRDCLOUD_SET:
            case TW_APP_CLOUD_THIRDCLOUD_QUERY:
            case TW_APP_CLOUD_THIRDCLOUD_PASSTHROUGH:
            case TW_APP_CLOUD_THIRDCLOUD_REPORT:

                BaseData baseData = new BaseData.Builder()
                        .channelMqtt()
                        .topic(TopicManager.getInstance().getCloudPubTopic())
                        .data(data.getBytes())
                        .build();
                doSend(baseData, new ICallListener() {
                    @Override
                    public void onSuccess() {

                    }

                    @Override
                    public void onFailed(int error) {
                        if (hdListener != null) {

                                hdListener.onSendFailed(data, error);

                        }
                    }
                });
                break;
            default:
                CLog.e(TAG, "unsupport msgtw");
                if (hdListener != null) {
                    hdListener.onSendFailed(data, QXErrorCode.ERROR_MSGTW);
                }
        }

    }


    @Override
    public void HDLogin(HDLoginReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDLoginQXMsg(req)), callListener);
    }

    @Override
    public void HDUpdateUserLoginPwd(HDUpdateUserLoginPwdReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDUpdateUserLoginPwdQXMsg(req)), callListener);
    }

    @Override
    public void HDGetTeamInfo(HDGetTeamInfoReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDTeamInfo(req)), callListener);
    }

    @Override
    public void HDGetTripRecord(HDGetTripRecordReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDTripRecordQXMsg(req)), callListener);
    }

    @Override
    public void HDGetTripDetail(HDGetTripDetailReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDTripDetailQXMsg(req)), callListener);
    }

    @Override
    public void HDGetUserInfo(HDGetUserInfoReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getHDUserInfoQXMsg(req)), callListener);
    }

}
