package cn.com.startai.qxcommon.utils;

import android.text.TextUtils;

import cn.com.startai.common.utils.CDeviceInfoUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CMD5;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class SnUtils {


    private SnUtils() {
    }

    public static SnUtils getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final SnUtils singleTonInstance = new SnUtils();
    }


    private long sn;

    /**
     * 获取sn
     *
     * @return
     */
    public long getSn(long appid) {
        if (appid == 0) {
            CLog.e(TAG, "appid is empty");
            return 0;
        }
        if (sn == 0) {
            sn = QXSpController.getInstance().getSn();
            if (sn == 0) {
                String mac = CDeviceInfoUtils.getMAC();//先获取以太网mac  如果没有则使用wifimac 如果再没有 就为空
                String serial = CDeviceInfoUtils.getCpuSerial();//cpu序列号，有可能为全0
                String androidId = CDeviceInfoUtils.getAndroidID();
                if ((serial.contains("0000") || TextUtils.isEmpty(serial)) && TextUtils.isEmpty(mac)) {
                    return 0;
                }
                String snStr = CMD5.generateMD5(androidId + serial + mac);
                snStr = CMD5.generateMD5(snStr + appid);
                sn = getQXEncodeHash(snStr);
                QXSpController.getInstance().setSn(sn);
            }
            CLog.d(TAG, "sn = " + sn);
        }

        return sn;
    }

    public long getQXEncodeHash(String oriString) {

        long hash = oriString.hashCode();

        hash = getUnSignNum(hash);

        char[] chars = oriString.toCharArray();
        long oriStrChar = 0;
        for (char c : chars) {
            oriStrChar += c;
        }
        long l = Long.parseLong(oriStrChar + "" + hash);
        return l;
    }

    public long getUnSignNum(long num) {
        if (num < 0) {
            num = (num << 32) >>> 32;
        }
        return num;
    }
}
