package cn.com.startai.qxcommon.utils;

import android.text.TextUtils;

import cn.com.startai.common.utils.AShareUtils;
import cn.com.startai.common.utils.CAppUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostResp;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;
import cn.com.startai.qxcommon.utils.location.AreaLocation;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXSpController {


    private QXSpController() {
    }

    public static QXSpController getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXSpController singleTonInstance = new QXSpController();
    }

    AShareUtils shareUtils;

    public void init() {
        shareUtils = new AShareUtils() {
            @Override
            protected String getSpName() {
                return CAppUtils.getAppPackageName() + "_sp";
            }
        };
    }

    public void release() {
        CLog.d(TAG, "QXSpController release");
        shareUtils = null;

    }

    private static final String SP_BROKER_HOST = "SP_BROKER_HOST";

    /**
     * 获取可用 broker节点
     *
     * @return
     */
    public GetBrokerHostResp getBrokerHost() {
        if (shareUtils == null) {
            return null;
        }
        String s = shareUtils.getString(SP_BROKER_HOST, "");
        if (TextUtils.isEmpty(s)) {
            return null;
        } else {
            GetBrokerHostResp contentBean = QXJsonUtils.fromJson(s, GetBrokerHostResp.class);
            if (contentBean == null) {
                return null;
            } else {
                if (contentBean.getNode() == null || contentBean.getNode().size() == 0) {
                    return null;
                }
            }
            return QXJsonUtils.fromJson(s, GetBrokerHostResp.class);
        }
    }

    /**
     * 保存 broker节点
     *
     * @param contentBean
     */
    public void setBrokerHost(GetBrokerHostResp contentBean) {
        if (shareUtils == null) {
            return;
        }
        if (contentBean == null) {
            shareUtils.putString(SP_BROKER_HOST, "");
            return;
        }
        String s = QXJsonUtils.toJson(contentBean);
        shareUtils.putString(SP_BROKER_HOST, s);
    }


    private static final String SP_LOCATION = "SP_LOCATION";

    /**
     * 获取 位置
     *
     * @return
     */
    public AreaLocation getLocation() {
        if (shareUtils == null) {
            return null;
        }
        String str = shareUtils.getString(SP_LOCATION, "");
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        return QXJsonUtils.fromJson(str, AreaLocation.class);
    }

    /**
     * 保存位置
     *
     * @param areaLocation
     */
    public void setLocation(AreaLocation areaLocation) {
        if (shareUtils == null) {
            return;
        }
        if (areaLocation == null) {
            shareUtils.putString(SP_LOCATION, "");
        } else {
            shareUtils.putString(SP_LOCATION, QXJsonUtils.toJson(areaLocation));
        }

    }


    private static final String SP_THIRDCLOUD_APPID = "SP_THIRDCLOUD_APPID";

    /**
     * 获取 平台 appid
     *
     * @return
     */
    public long getThirdCloudAppid() {
        if (shareUtils == null) {
            return 0;
        }
        return shareUtils.getLong(SP_THIRDCLOUD_APPID + ParamManager.getInstance().getAppid(), 0);
    }

    /**
     * 保存 平台 appid
     *
     * @param appid
     */
    public void setThirdCloudAppid(long appid) {
        if (shareUtils == null) {
            return;
        }

        shareUtils.putLong(SP_THIRDCLOUD_APPID + ParamManager.getInstance().getAppid(), appid);
    }


    private static final String SP_SN = "SP_SN";

    /**
     * 获取 sn
     *
     * @return
     */
    public long getSn() {
        if (shareUtils == null) {
            return 0;
        }
        return shareUtils.getLong(SP_SN, 0);
    }

    /**
     * 保存 sn
     *
     * @param sn
     */
    public void setSn(long sn) {
        if (shareUtils == null) {
            return;
        }

        shareUtils.putLong(SP_SN, sn);
    }


    private static final String SP_CUSTOM = "SP_CUSTOM";

    /**
     * 获取 custom
     *
     * @return
     */
    public int getCustom() {
        if (shareUtils == null) {
            return 0;
        }
        return shareUtils.getInt(SP_CUSTOM + ParamManager.getInstance().getAppid(), 0);
    }

    /**
     * 保存 custom
     *
     * @param custom
     */
    public void setCustom(int custom) {
        if (shareUtils == null) {
            return;
        }

        shareUtils.putInt(SP_CUSTOM + ParamManager.getInstance().getAppid(), custom);
    }


    private static final String SP_PRODUCT = "SP_PRODUCT";

    /**
     * 获取 product
     *
     * @return
     */
    public int getProduct() {
        if (shareUtils == null) {
            return 0;
        }
        return shareUtils.getInt(SP_PRODUCT + ParamManager.getInstance().getAppid(), 0);
    }

    /**
     * 保存 product
     *
     * @param product
     */
    public void setProduct(int product) {
        if (shareUtils == null) {
            return;
        }

        shareUtils.putInt(SP_PRODUCT + ParamManager.getInstance().getAppid(), product);
    }


    private static final String SP_ACTIVITE = "SP_ACTIVITE";

    /**
     * 查本地激活状态
     *
     * @return
     */
    public boolean getIsActivite() {
        if (shareUtils == null) {
            return false;
        }
        long appid = ParamManager.getInstance().getAppid();
        //如果appid变化了会重新激活
        boolean aBoolean = shareUtils.getBoolean(SP_ACTIVITE + appid + SnUtils.getInstance().getSn(appid), false);
        return aBoolean;
    }

    /**
     * 保存激活状态
     */
    public void setIsActivite(boolean isActivite) {
        if (shareUtils == null) {
            return;
        }
        long appid = ParamManager.getInstance().getAppid();
        shareUtils.putBoolean(SP_ACTIVITE + appid + SnUtils.getInstance().getSn(appid), isActivite);
    }


//    private static final String SP_CLIENTID = "SP_CLIENTID";
//
//    /**
//     * 查本地的clientid
//     *
//     * @return
//     */
//    public String getClientid() {
//        if (shareUtils == null) {
//            return null;
//        }
//        return shareUtils.getString(SP_CLIENTID, "");
//    }
//
//    /**
//     * 保存clientid到本地
//     */
//    public void setClientid(String clientid) {
//        if (shareUtils == null) {
//            return;
//        }
//        shareUtils.putString(SP_CLIENTID, clientid);
//    }


    private static final String SP_LASTGET_BROKERHOST_TIME = "SP_LASTGET_BROKERHOST_TIME";

    /**
     * 获取上次同步broker节点的时间
     *
     * @return
     */
    public long getLastGetBrokerHostrespTime() {
        if (shareUtils == null) {
            return 0;
        }
        long aLong = shareUtils.getLong(SP_LASTGET_BROKERHOST_TIME, 0);

        return aLong;
    }

    /**
     * 保存此次同步broker节点的时间
     *
     * @param time
     */
    public void setLastGetBrokerHostrespTime(long time) {
        if (shareUtils == null) {
            return;
        }
        shareUtils.putLong(SP_LASTGET_BROKERHOST_TIME, time);

    }

}
