package cn.com.startai.qxcommon.protocol;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息转换类
 * Created by Robin on 2019/5/24.
 * 419109715@qq.com 彬影
 */
public class QXMessageConverter {

    private QXMessageConverter() {
    }

    public static QXMessageConverter getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXMessageConverter singleTonInstance = new QXMessageConverter();
    }


    private Map<Long, QXMessage> cacheFromMessage = new HashMap<>();

    public void onReceive(QXMessage message) {
        cacheFromMessage.put(message.getContent().getCmd(), message);
    }



    public QXMessage getBackMessageByFromCmd(long cmd) {

        QXMessage qxMessage = cacheFromMessage.remove(cmd);
        if (qxMessage != null) {
            qxMessage = getBackQxMsgByFromQxMsg(qxMessage);
        } else {
            QXBaseContentImpl baseContent = new QXBaseContentImpl();
            baseContent.setCmd(cmd);
            qxMessage = QXDataCreater.getAppReportQXMsg(0, baseContent);
        }
        qxMessage.setTs(System.currentTimeMillis());
        return qxMessage;
    }

    public <T extends QXBaseContent> QXMessage<T> getBackQxMsgByFromQxMsg(QXMessage<T> from) {

        QXMessage<T> qxMessage = new QXMessage<T>().new Builder()
                .from(from.getTo())
                .to(from.getFrom())
                .appid(from.getAppid())
                .ver(from.getVer())
                .session(from.getSession())
                .ts(System.currentTimeMillis())
                .msgtw(from.getMsgtw())
                .content(from.getContent())
                .build();

        return qxMessage;
    }

}
