package cn.com.startai.qxcommon.link.mqtt.busi.bean;

import android.support.annotation.NonNull;

import java.util.List;

import cn.com.startai.common.utils.CLog;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class GetBrokerHostResp extends GetBrokerHostReq {

    private int cycle;
    private List<NodeBean> node;

    @Override
    public String toString() {
        return "GetBrokerHostResp{" +
                "result=" + result +
                ", cycle=" + cycle +
                ", node=" + node +
                ", custom=" + custom +
                ", product=" + product +
                ", cmd=" + cmd +
                '}';
    }

    public int getCycle() {
        return cycle;
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    public List<NodeBean> getNode() {
        return node;
    }

    public void setNode(List<NodeBean> node) {
        this.node = node;
    }


    public NodeBean getOptimalNode() {

        NodeBean optimalNodeBean = null;
        for (NodeBean nodeBean : node) {
            CLog.d(TAG, nodeBean.getServer_domain() + " " + nodeBean.getWeight());

            if (optimalNodeBean == null) {
                optimalNodeBean = nodeBean;
            } else {
                if (optimalNodeBean.getWeight() < nodeBean.getWeight()) {
                    optimalNodeBean = nodeBean;
                }
            }
        }
        if (optimalNodeBean.getWeight() <= 0) {
            optimalNodeBean = null;
        }
        return optimalNodeBean;
    }

    public NodeBean matchByCountryCode(@NonNull String countryCode) {

        for (NodeBean nodeBean : node) {

            if (nodeBean.getServer_domain().toUpperCase().contains(countryCode.toUpperCase())) {
                return nodeBean;
            }

        }
        return null;
    }

    public NodeBean getNodeByHost(@NonNull String host) {
        for (NodeBean nodeBean : node) {
            if (host.equals(nodeBean.getServer_domain())) {
                return nodeBean;
            }
        }
        return null;
    }

    public static class NodeBean {
        /**
         * server_domain : ssl:// cn.startai.net:8883
         * ip : 47.106.45.110
         * port : 8883
         * protocol : ssl
         * weight : 1
         */
        private String continent;
        private String country;
        private String ip;
        private int port;
        private String protocol;
        private String server_domain;
        private double weight;

        @Override
        public String toString() {
            return "NodeBean{" +
                    "continent='" + continent + '\'' +
                    ", country='" + country + '\'' +
                    ", ip='" + ip + '\'' +
                    ", port=" + port +
                    ", protocol='" + protocol + '\'' +
                    ", server_domain='" + server_domain + '\'' +
                    ", weight=" + weight +
                    '}';
        }

        public NodeBean(String continent, String country, String ip, int port, String protocol, String server_domain, double weight) {
            this.continent = continent;
            this.country = country;
            this.ip = ip;
            this.port = port;
            this.protocol = protocol;
            this.server_domain = server_domain;
            this.weight = weight;
        }

        public String getContinent() {
            return continent;
        }

        public void setContinent(String continent) {
            this.continent = continent;
        }

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getServer_domain() {
            return server_domain;
        }

        public void setServer_domain(String server_domain) {
            this.server_domain = server_domain;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public int getPort() {
            return port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getProtocol() {
            return protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public double getWeight() {
            return weight;
        }

        public void setWeight(double weight) {

            this.weight = weight;
        }


    }
}
