package cn.com.startai.qxcommon.link.mqtt.busi;



import org.json.JSONException;
import org.json.JSONObject;

import java.nio.charset.Charset;

import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.link.ABusiHandler;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateResp;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostResp;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.UpdateDeviceInfoResp;
import cn.com.startai.qxcommon.protocol.Cmd;
import cn.com.startai.qxcommon.protocol.MiofTag;
import cn.com.startai.qxcommon.link.mqtt.event.IMqttBusiListener;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2018/6/14.
 * qq: 419109715 彬影
 */

public class MqttBusiHandler extends ABusiHandler implements Cmd {
    private IMqttBusiListener mqttBusiListener;

    public MqttBusiHandler(IMqttBusiListener mqttBusiListener) {
        this.mqttBusiListener = mqttBusiListener;
    }

    @Override
    public boolean handlerMessage(BaseData baseData) {
        String json = "";
        long cmd = 0;
        try {
            byte[] data = baseData.getData();
            json = new String(data, Charset.forName("utf-8"));
            JSONObject jsonObject = new JSONObject(json);
            if (json.contains("\"" + MiofTag.TAG_CMD + "\"")
                    && json.contains("\"" + MiofTag.TAG_MSGTW + "\"")) {
                cmd = jsonObject.getJSONObject(MiofTag.TAG_CONTENT).getLong(MiofTag.TAG_CMD);
            }
        } catch (JSONException e) {
            CLog.e(TAG, "JSON format error");
            e.printStackTrace();
            return false;
        }
        if (cmd != 0) {
            if (cmd == ACTIVATE) {
                QXMessage<ActivateResp> activateCtnRespQXMessage = QXJsonUtils.fromJsonToQXMessage(json, ActivateResp.class);
                if (activateCtnRespQXMessage == null) {
                    return false;
                }
                if (ParamManager.getInstance().getSn() == activateCtnRespQXMessage.getContent().getSn()) {
                    if (mqttBusiListener != null) {
                        mqttBusiListener.onActivateResult(activateCtnRespQXMessage);
                    }
                    return true;
                } else {
                    return false;
                }
            } else if (cmd == GET_BROKER_HOST) {

                QXMessage<GetBrokerHostResp> getBrokerHostCtnRespQXMessage = QXJsonUtils.fromJsonToQXMessage(json, GetBrokerHostResp.class);
                if (mqttBusiListener != null) {
                    mqttBusiListener.onGetBrokerHostResult(getBrokerHostCtnRespQXMessage);
                }
                return true;
            } else if (cmd == UPDATE_DEVICE_INFO) {
                QXMessage<UpdateDeviceInfoResp> updateDeviceInfoRespQXMessage = QXJsonUtils.fromJsonToQXMessage(json, UpdateDeviceInfoResp.class);
                if (mqttBusiListener != null) {
                    mqttBusiListener.onUpdateDeviceInfoResult(updateDeviceInfoRespQXMessage);
                }
                return true;
            }
        }

        return false;
    }


}
