package cn.com.startai.qxcommon.link.mqtt;

import java.io.Serializable;

import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.SnUtils;

import static cn.com.startai.qxcommon.protocol.IDeveloper.MsgTw.*;


/**
 * 名称：主题管理
 * 描述：
 * Created by Robin on 2016-7-6
 * QQ 419109715 彬影
 */
public class TopicManager implements Serializable {

    public static final String SERVICE_TOPIC = "SERVICE/";
    public static final String CLOUD_TOID = "Cloud/BXTM";
    public static final String Q_WILL = "Q/client/will";
    public static final String Q_APPTYPE = "Q/apptype";
    public static final String Q_CLIENT = "Q/client";
    public static final String EXT_A = "-A";
    public static final String Q_NODE = "Q/node";
    public static final String Q_AREA = "Q/area";
    public static final String NMC_TOPIC = "SERVICE/NMC";
    public static final String CDN_TOPIC = "SERVICE/CDN";
    public static final String ALARM_TOPIC = "alarm";
    public static final String DISTRIBUTE = "distribute";


    private TopicManager() {
    }

    public static TopicManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final TopicManager singleTonInstance = new TopicManager();
    }


    /**
     * 自己订阅的userId相关主题
     *
     * @param userId
     * @return
     */
    public String getUserSubTopic(long userId) {
        String userTopic = TopicManager.Q_CLIENT + "/" + userId + "/#";
        return userTopic;
    }

    /**
     * 自己订阅的sn相关主题
     *
     * @return
     */
    public String getSnSubTopic() {
        String snTopic = TopicManager.Q_CLIENT + "/" + SnUtils.getInstance().getSn(ParamManager.getInstance().getAppid()) + "/#";
        return snTopic;
    }


    /**
     * 向平台发送消息的主题
     *
     * @return
     */
    public String getThirdCloudPubTopic() {
        return NMC_TOPIC + "/" + QXSpController.getInstance().getThirdCloudAppid();
    }

    /**
     * 向基础服务发送消息的主题
     *
     * @return
     */
    public String getCloudPubTopic() {
        return NMC_TOPIC + "/" + ParamManager.getInstance().getAppid();
    }

    /**
     * 向智能设备发送消息的主题
     *
     * @param sn
     * @return
     */
    public String getClientPubTopic(long sn) {
        return Q_CLIENT + "/" + sn;
    }


    /**
     * 订阅对端的消息上报主题
     *
     * @param friendSn
     * @return
     */
    public String getFriendWillSubTopic(String friendSn) {

        return Q_WILL + "/+/" + friendSn;
    }

    /**
     * 订阅对端的遗嘱主题
     *
     * @param friendSn
     * @return
     */
    public String getFriendReportSubTopic(String friendSn) {

        return Q_CLIENT + "/" + friendSn + EXT_A;

    }

    public String getTopicByMsgTwAndTo(int msgtw, long to) {


        switch (msgtw) {
            case TW_APP_CLOUD_ALARM:
            case TW_APP_CLOUD_REPORT:
            case TW_APP_CLOUD_PASSTHROUGH:
            case TW_APP_CLOUD_SET:
            case TW_APP_CLOUD_QUERY:
                return getCloudPubTopic();
            case TW_APP_CLOUD_THIRDCLOUD_ALARM:
            case TW_APP_CLOUD_THIRDCLOUD_SET:
            case TW_APP_CLOUD_THIRDCLOUD_REPORT:
            case TW_APP_CLOUD_THIRDCLOUD_QUERY:
            case TW_APP_CLOUD_THIRDCLOUD_PASSTHROUGH:
                return getThirdCloudPubTopic();
            case TW_APP_THIRDCLOUD_ALARM:
            case TW_APP_THIRDCLOUD_SET:
            case TW_APP_THIRDCLOUD_QUERY:
            case TW_APP_THIRDCLOUD_PASSTHROUGH:
            case TW_APP_THIRDCLOUD_REPORT:
                return getClientPubTopic(to);
            case TW_APP_DEVICE_ALARM:
            case TW_APP_DEVICE_REPORT:
            case TW_APP_DEVICE_QUERY:
            case TW_APP_DEVICE_SET:
            case TW_APP_DEVICE_PASSTHROUGH:
                return getClientPubTopic(to);
            default:
                return getCloudPubTopic();
        }
    }

}