package cn.com.startai.qxcommon.global;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.qxcommon.QXCommon;
import cn.com.startai.qxcommon.db.QXDBManager;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.link.mqtt.QXMqttManager;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;

/**
 * Created by Robin on 2019/3/8.
 * 419109715@qq.com 彬影
 */
public class QXUserManager {

    //将构造函数私有化
    private QXUserManager() {
    }

    public static QXUserManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }

    //静态内部类
    public static class SingleTonHoulder {
        private static final QXUserManager singleTonInstance = new QXUserManager();
    }


    private long userId;
    private UserBean userBean;

    public UserBean getUserBean() {
        if (QXCommon.getInstance().getApp() == null) {
            return null;
        }
        if (userBean == null) {
            userBean = QXDBManager.getInstance().getUserByLoginStatus(1);
            if (userBean != null) {
                userId = userBean.getUserId();
            }
        }
        return userBean;
    }

    public void setUserBean(UserBean userBean) {
        this.userBean = userBean;
    }

    public long getUserId() {
        if (QXCommon.getInstance().getApp() == null) {
            return 0;
        }
        getUserBean();
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public void checkNeedToUnsubUserTopic() {

        final ArrayList<UserBean> allUser = QXDBManager.getInstance().getAllUser();

        final List<String> unSubList = new ArrayList<>();
        for (UserBean bean : allUser) {
            if (bean.getLoginStatus() == 0) {
                unSubList.add(TopicManager.getInstance().getUserSubTopic(bean.getUserId()));
            }
        }

        if (unSubList.size() > 0) {
            QXMqttManager.getInstance().unSubscribe(unSubList, new ICallListener() {
                @Override
                public void onSuccess() {
                    QXDBManager.getInstance().deleteUserByLoginStatus(0);
                }

                @Override
                public void onFailed(int i) {

                }
            });
        }
    }


    public void onLogin(final UserBean userBean) {

        QXDBManager.getInstance().resetUser();
        userBean.setLoginStatus(1);
        onUpdateUserInfo(userBean);

        final ArrayList<UserBean> allUser = QXDBManager.getInstance().getAllUser();
        List<String> subList = new ArrayList<>();
        final List<String> unSubList = new ArrayList<>();
        for (UserBean bean : allUser) {
            if (bean.getLoginStatus() == 0) {
                unSubList.add(TopicManager.getInstance().getUserSubTopic(bean.getUserId()));
            } else {
                subList.add(TopicManager.getInstance().getUserSubTopic(bean.getUserId()));
            }
        }

        if (subList.size() > 0) {
            QXMqttManager.getInstance().subscribeSync(subList, new ICallListener() {
                @Override
                public void onSuccess() {
                    if (unSubList.size() > 0) {
                        QXMqttManager.getInstance().unSubscribe(unSubList, new ICallListener() {
                            @Override
                            public void onSuccess() {
                                QXDBManager.getInstance().deleteUserByLoginStatus(0);
                            }

                            @Override
                            public void onFailed(int i) {

                            }
                        });
                    }
                }

                @Override
                public void onFailed(int i) {

                }
            });
        }
    }


    public void onUpdateUserInfo(UserBean userBean) {

        QXDBManager.getInstance().addOrUpdateUser(userBean);

    }

    public void onLogout() {

        List<String> ls = new ArrayList<>();
        long userId = getUserId();
        if (userId != 0) {
            ls.add(TopicManager.getInstance().getUserSubTopic(userId));
            QXMqttManager.getInstance().unSubscribe(ls, new ICallListener() {
                @Override
                public void onSuccess() {
                    QXDBManager.getInstance().deleteUserByUserid(userBean.getUserId());
                    userBean = null;
                    QXUserManager.this.userId = 0;
                }

                @Override
                public void onFailed(int i) {
                    userBean = null;
                    QXUserManager.this.userId = 0;
                    QXDBManager.getInstance().resetUser();
                }
            });
        }
    }
}
