package cn.com.startai.qxcommon.busi.qx;


import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.network.INetworkListener;
import cn.com.startai.qxcommon.event.IQXCommonListener;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.protocol.QXBaseContentImpl;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public abstract class AQXBusiListener implements INetworkListener, IQXCommonListener {


    public abstract void onQXLogoutResult(boolean result);

    public abstract void onQXGetUserInfoResult();

    @Override
    public void onMessageArrived(BaseData baseData) {

        QXMessage<QXBaseContentImpl> qxMessageBean = QXJsonUtils.fromJsonToQXMessage(new String(baseData.getData()), QXBaseContentImpl.class);
        CLog.d(TAG, "qxMessage = " + qxMessageBean);
    }

    public abstract void onQXActivateResult();

    public abstract void onQXLoginResult();

}
