package cn.com.startai.qxcommon.busi.huadian;

import android.app.Application;
import android.telecom.Call;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdReq;
import cn.com.startai.qxcommon.busi.qx.IQxBusi;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public interface IHDTrainerBusi extends IQxBusi {

    /**
     * 初始化后不会自动连接服务器
     *
     * @param application
     * @param listener
     */
    void init(Application application, AHDTrainerListener listener);

    /**
     * 协议消息发送
     *
     * @param data
     * @param callListener
     */
    void doSend(String data, ICallListener callListener);

    /**
     * 华点登录
     *
     * @param req
     * @param callListener
     */
    void HDLogin(HDLoginReq req, ICallListener callListener);

    /**
     * 华点 更新用户登录密码
     *
     * @param req
     * @param callListener
     */
    void HDUpdateUserLoginPwd(HDUpdateUserLoginPwdReq req, ICallListener callListener);

    /**
     * 华点 获取班级信息
     *
     * @param req
     * @param callListener
     */
    void HDGetTeamInfo(HDGetTeamInfoReq req, ICallListener callListener);

    /**
     * 华点 获取出乘记录
     *
     * @param req
     * @param callListener
     */
    void HDGetTripRecord(HDGetTripRecordReq req, ICallListener callListener);

    /**
     * 华点 获取 出乘详情
     *
     * @param req
     * @param callListener
     */
    void HDGetTripDetail(HDGetTripDetailReq req, ICallListener callListener);

    /**
     * 华点 获取用户信息
     *
     * @param req
     * @param callListener
     */
    void HDGetUserInfo(HDGetUserInfoReq req, ICallListener callListener);


}
