package cn.com.startai.qxcommon.busi.huadian;


import android.net.NetworkInfo;

import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDInitResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDNetworkStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDServerConnectStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdResp;
import cn.com.startai.qxcommon.busi.qx.AQXBusiListener;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.global.DeveloperParam;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.QXBaseContentImpl;
import cn.com.startai.qxcommon.protocol.QXMessage;

import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public abstract class AHDTrainerListener extends AQXBusiListener implements HDCmd {


    // ---------- INetworkListener start ----------
    @Override
    public void onWifiConnected() {

    }

    @Override
    public void onMobileConnected() {

    }

    @Override
    public void onEthernetConnected() {

    }

    @Override
    public void onUnkownNetwork() {

    }

    @Override
    public void onNetworkStateChange(String s, NetworkInfo.State state) {
        callbackNetworkState(s, state);
    }

    // ---------- INetworkListener end ----------


    // ---------- IQXCommonListener start ----------


    @Override
    public void onServerConnected(String host) {
        if (!HDTrainer.getInstance().isHasCallbackInit()) {
            onInitSuccess(ParamManager.getInstance().getDeveloperParam());
            HDTrainer.getInstance().setHasCallbackInit(true);
        }
        callbackServerConnectState(MqttConnectState.CONNECTED);
    }

    @Override
    public void onServerDisconnected(int errorCode) {
        callbackServerConnectState(MqttConnectState.DISCONNECTED);
    }

    @Override
    public void onMessageArrived(BaseData baseData) {
        super.onMessageArrived(baseData);

        String json = new String(baseData.getData());
        QXMessage<QXBaseContentImpl> baseBean = QXJsonUtils.fromJsonToQXMessage(json, QXBaseContentImpl.class);

        if (baseBean != null && baseBean.getContent() != null) {
            long cmd = baseBean.getContent().getCmd();
            if (cmd == HD_LOGIN) {
                onHDLoginResult(QXJsonUtils.fromJsonToQXMessage(json, HDLoginResp.class));
            } else if (cmd == HD_UPDATE_USER_LOGIN_PWD) {
                onHDUpdateUserLoginPwdResult(QXJsonUtils.fromJsonToQXMessage(json, HDUpdateUserLoginPwdResp.class));
            } else if (cmd == HD_GET_TRIP_RECORD) {
                onHDGetTripRecordResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTripRecordResp.class));
            } else if (cmd == HD_GET_TRIP_DETAIL) {
                onHDGetTripDeatilResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTripDetailResp.class));
            } else if (cmd == HD_GET_TEAM_INFO) {
                onHDGetTeamInfoResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTeamInfoResp.class));
            } else if (cmd == HD_GET_USER_INFO) {
                onHDGetUserInfoResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetUserInfoResp.class));
            } else {
                CLog.e(TAG, "unsupport recv cmd ");
            }

        } else {
            CLog.e(TAG, "error data formate");
        }

    }

    // ---------- IQXCommonListener end ----------


    // ---------- AQXBusiListener start ----------

    @Override
    public void onQXGetUserInfoResult() {

    }

    @Override
    public void onQXLogoutResult(boolean result) {

        QXMessage message = QXMessageConverter.getInstance().getBackMessageByFromCmd(SDK_LOGOUT);
        message.getContent().setResult(IDeveloper.Result.SUCCESS);
        onHDMessageArrived(QXJsonUtils.toJson(message));

    }

    @Override
    public void onQXActivateResult() {

    }

    @Override
    public void onQXLoginResult() {

    }
    // ---------- AQXBusiListener end ----------

    // ---------- AHDTrainerListener start ----------

    public void onHDGetUserInfoResult(QXMessage<HDGetUserInfoResp> qxMessage) {
        if (qxMessage.getContent().getResult() == HDLoginResp.SUCCESS) {
            UserBean userBean = qxMessage.getContent().toUserBean();
            QXUserManager.getInstance().onUpdateUserInfo(userBean);
        }
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));
    }


    public void onHDLoginResult(QXMessage<HDLoginResp> qxMessage) {
        if (qxMessage.getContent().getResult() == HDLoginResp.SUCCESS) {

            long l;
            try {
                l = Long.parseLong(qxMessage.getContent().getUserId());
            } catch (Exception e) {
                e.printStackTrace();
                CLog.e(TAG, "login failed user error");
                return;
            }
            UserBean userBean = new UserBean.Builder()
                    .userId(l)
                    .token(qxMessage.getContent().getToken())
                    .build();
            QXUserManager.getInstance().onLogin(userBean);
        }
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));

    }

    public void onHDGetTripDeatilResult(QXMessage<HDGetTripDetailResp> qxMessage) {
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));
    }

    public void onHDGetTripRecordResult(QXMessage<HDGetTripRecordResp> qxMessage) {
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));
    }

    public void onHDGetTeamInfoResult(QXMessage<HDGetTeamInfoResp> qxMessage) {
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));
    }

    public void onHDUpdateUserLoginPwdResult(QXMessage<HDUpdateUserLoginPwdResp> qxMessage) {
        onHDMessageArrived(QXJsonUtils.toJson(qxMessage));
    }

    public void callbackNetworkState(String networkType, NetworkInfo.State netwrokState) {

        QXMessage message = QXMessageConverter.getInstance().getBackMessageByFromCmd(SDK_NETWORK_STATE);
        HDNetworkStateResp content = new HDNetworkStateResp(networkType, netwrokState.name());
        content.setResult(HDServerConnectStateResp.SUCCESS);
        message.setContent(content);
        onHDMessageArrived(message.toJson());
    }

    public void callbackServerConnectState(MqttConnectState mqttConnectState) {
        QXMessage message = QXMessageConverter.getInstance().getBackMessageByFromCmd(SDK_SERVER_CONNECT_STATE);
        HDServerConnectStateResp content = new HDServerConnectStateResp(mqttConnectState.name());
        content.setResult(HDServerConnectStateResp.SUCCESS);
        message.setContent(content);
        onHDMessageArrived(message.toJson());
    }

    public void onInitSuccess(DeveloperParam initCtnResp) {
        if (initCtnResp != null) {
            initCtnResp.setCmd(HDCmd.SDK_INIT);
            initCtnResp.setResult(HDServerConnectStateResp.SUCCESS);
            QXMessage qxMessage = QXMessageConverter.getInstance().getBackMessageByFromCmd(initCtnResp.getCmd());
            qxMessage.setContent(initCtnResp);
            onHDMessageArrived(qxMessage.toJson());
        }
    }

    public abstract void onHDMessageArrived(String msg);

    // ---------- AHDTrainerListener end ----------
}
