package cn.com.startai.qxcommon.busi;


import android.app.Application;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.network.CNetworkManager;
import cn.com.startai.qxcommon.QXCommon;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.event.IQXCommonListener;
import cn.com.startai.qxcommon.event.QXEventDispatcher;
import cn.com.startai.qxcommon.link.BaseData;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public class CommonBusi implements ICommonBusi {

    protected Application application;
    protected QXCommonInitParam initParam;
    protected IQXCommonListener commonListener;

    @Override
    public void init(Application application, QXCommonInitParam initParam, IQXCommonListener commonListener) {
        if (application == null) {
            CLog.e(TAG, "please application = null");
            return;
        }
        this.commonListener = commonListener;
        this.application = application;
        this.initParam = initParam;
        QXEventDispatcher.getInstance().addQXCommonListener(this.commonListener);

        QXCommon.getInstance().init(application, initParam);

    }

    @Override
    public void release() {
        QXCommon.getInstance().release();
        QXEventDispatcher.getInstance().removeQXCommonListener(commonListener);
        this.application = null;
        this.commonListener = null;
        this.initParam = null;
    }

    @Override
    public void doSend(BaseData baseData, ICallListener listener) {
        QXCommon.getInstance().doSend(baseData, listener);
    }

    @Override
    public void doSendMqtt(BaseData qxMqttData, ICallListener listener) {
        QXCommon.getInstance().doSendMqtt(qxMqttData, listener);
    }

    @Override
    public void doSendUdp(BaseData qxudpData, ICallListener listener) {
        QXCommon.getInstance().doSendUdp(qxudpData, listener);
    }

    @Override
    public void doSendBle(BaseData qxbleData, ICallListener listener) {
        QXCommon.getInstance().doSendBle(qxbleData, listener);
    }
}
