package cn.com.startai.fssdk.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.com.startai.fssdk.utils.IpPortAddr;

/**
 * 名称：NetAddrUtil 描述：从url中获取ip port 及fid Created by Robin on 2016-7-10 QQ
 * 419109715 彬影
 */
public class NetAddrUtil {

	public NetAddrUtil() {
	}

	public static String getIpFromUrl(String url) {
		if (url != null && !url.trim().equals("")) {
			String host = "";
			Pattern p = Pattern.compile("(?<=//|)((\\w)+\\.)+\\w+");
			Matcher matcher = p.matcher(url);
			if (matcher.find()) {
				host = matcher.group();
			}

			return host;
		} else {
			return "";
		}
	}

	public static String getHttpUrlFromIpPortFileId(String ip, int port, String fileId) {
		return "http://" + ip + ":" + port + "/" + fileId;
	}

	public static String getTcpUrlFromIpPortFileId(String ip, int port, String fileId) {
		return "tcp://" + ip + ":" + port + "/" + fileId;
	}

	public static IpPortAddr getIpPortFromUrl(String url) {
		if (url != null && !url.trim().equals("")) {
			String host = "";
			Pattern p = Pattern.compile("(?<=//|)((\\w)+\\.)+\\w+(:\\d{0,5})?");
			Matcher matcher = p.matcher(url);
			if (matcher.find()) {
				host = matcher.group();
			}

			if (!host.contains(":")) {
				return new IpPortAddr(host, 80);
			} else {
				String[] ipPortArr = host.split(":");
				return new IpPortAddr(ipPortArr[0], Integer.parseInt(ipPortArr[1]));
			}
		} else {
			return null;
		}
	}

	public static String getFileIdFromUrl(String url) {
		String fileId = "";
		try {
			IpPortAddr ipPortFromUrl = getIpPortFromUrl(url);
			String port = String.valueOf(ipPortFromUrl.getPort());
			int start = url.indexOf(port) + port.length() + 1;
			fileId = url.substring(start);
			
			return fileId;
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return fileId;
	}

	public static void main(String[] args) {
		String url = "http://10.33.32.81:8080/login.action";
		System.out.println(getIpFromUrl(url));
		IpPortAddr addr = getIpPortFromUrl(url);
		System.out.println(addr.getIp() + "=========>" + addr.getPort());
	}

	/**
	 * URL检查<br>
	 * <br>
	 * 
	 * @param pInput
	 *            要检查的字符串<br>
	 * @return boolean 返回检查结果<br>
	 */
	public static boolean isUrl(String pInput) {
		try {
			if (pInput == null) {
				return false;
			}
			String regEx = "^(http|https|ftp|tcp)\\://([a-zA-Z0-9\\.\\-]+(\\:[a-zA-"
					+ "Z0-9\\.&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{"
					+ "2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}"
					+ "[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|"
					+ "[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-"
					+ "4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])|([a-zA-Z0"
					+ "-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(\\:[0-9]+)?(/"
					+ "[^/][a-zA-Z0-9\\.\\,\\?\\'\\\\/\\+&%\\$\\=~_\\-@]*)*$";
			Pattern p = Pattern.compile(regEx);
			Matcher matcher = p.matcher(pInput);
			if (matcher.matches()) {
				return true;
			} else {
				return isUrl(pInput.substring(0, pInput.lastIndexOf("/")));
			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}

}
