package cn.com.startai.fssdk.upload.dfs;

import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Log;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;

import cn.com.startai.fssdk.BaseUploader;
import cn.com.startai.fssdk.StartaiUploaderManager;
import cn.com.startai.fssdk.common.MyException;
import cn.com.startai.fssdk.db.FDBManager;
import cn.com.startai.fssdk.db.entity.UploadBean;
import cn.com.startai.fssdk.event.FSEventDispatcher;
import cn.com.startai.fssdk.utils.FLog;
import cn.com.startai.fssdk.FSUploadCallback;
import cn.com.startai.fssdk.fastdfs.ClientGlobal;
import cn.com.startai.fssdk.fastdfs.FileInfo;
import cn.com.startai.fssdk.fastdfs.StorageClient1;
import cn.com.startai.fssdk.fastdfs.StorageServer;
import cn.com.startai.fssdk.fastdfs.TrackerClient;
import cn.com.startai.fssdk.fastdfs.TrackerGroup;
import cn.com.startai.fssdk.fastdfs.TrackerServer;
import cn.com.startai.fssdk.utils.FSConsts;


/**
 * 名称：StartaiUploader
 * 描述：上传器
 * Created by Robin on 2016-10-9
 * QQ 419109715 彬影
 */
public class StartaiUploader extends BaseUploader implements Runnable {

    private FSUploadCallback callback;
    private TrackerGroup trackerGroup;
    private String TAG = this.getClass().getSimpleName();
    private boolean FlagUploading = true;

    private StorageClient1 client;
    private StorageServer storageServer;
    private TrackerServer trackerServer;

    private UploadBean uploadEntity;

    public StartaiUploader(UploadBean entity, FSUploadCallback callback) {
        this.uploadEntity = entity;
        this.callback = callback;
    }

    @Override
    public UploadBean getUploadBean() {
        return uploadEntity;
    }

    private long start;

    @Override
    public int getUploadStatus() {
        return 0;
    }

    public void stopUpload() {
        close();
        FlagUploading = false;
    }


    @Override
    public void retry(int times) {

    }

    private void close() {
        try {
            if (trackerServer != null) {
                trackerServer.close();
            }
            if (storageServer != null) {
                storageServer.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onProgress(final UploadBean uploadBean) {
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(1);
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);
                if (callback != null) {
                    callback.onProgress(uploadBean);
                } else {
                    FSEventDispatcher.getInstance().onUploadProgress(uploadBean);

                }
            }
        });
    }

    @Override
    public void onWaiting(final UploadBean uploadBean) {
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(3);
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);

                if (callback != null) {
                    callback.onWaiting(uploadBean);
                } else {
                    FSEventDispatcher.getInstance().onUploadWaiting(uploadBean);
                }
            }
        });
    }

    @Override
    public void onStart(final UploadBean uploadBean) {
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(1);
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);
                if (callback != null) {
                    callback.onStart(uploadBean);
                } else {
                    FSEventDispatcher.getInstance().onUploadStart(uploadBean);
                }
            }
        });
    }

    @Override
    public void onSuccess(final UploadBean uploadBean) {
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(2);
                uploadBean.setHttpDownloadUrl("http://" + uploadBean.getUploadIP() + ":" + FSConsts.FAST_DFS_HTTP_PORT + "/" + uploadBean.getFileId());
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);
                if (callback != null) {
                    callback.onSuccess(uploadBean);
                } else {
                    FSEventDispatcher.getInstance().onUploadSuccess(uploadBean);
                }

                StartaiUploaderManager.getInstance().toUpload();
            }
        });
    }

    @Override
    public void onFailue(final UploadBean uploadBean, final int errorCode) {
        if (!FlagUploading) {
            onPause(uploadBean);
            return;
        }
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(4);
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);

                if (callback != null) {
                    callback.onFailure(uploadBean, errorCode);
                } else {
                    FSEventDispatcher.getInstance().onUploadFailure(uploadBean, errorCode);
                }

                StartaiUploaderManager.getInstance().toUpload();
            }
        });
    }

    @Override
    public void onPause(final UploadBean uploadBean) {
        StartaiUploaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                uploadBean.setStatus(0);
                FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);

                if (callback != null) {
                    callback.onPause(uploadBean);
                } else {
                    FSEventDispatcher.getInstance().onUploadPause(uploadBean);
                }

                StartaiUploaderManager.getInstance().toUpload();
            }
        });
    }


    @Override
    public void run() {

        String uploadIP = uploadEntity.getUploadIP();
        int uploadPort = uploadEntity.getUploadPort();
        FLog.d(TAG, "ip = " + uploadIP + " port = " + uploadPort);
        initClientGlobal(uploadIP, uploadPort);

        try {
            client = getStorageClient1();
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "连接文件服务器失败");
            onFailue(uploadEntity, ERROR_CODE_CONN_SERVER_FAILED);
            return;
        }
        if (client == null) {
            Log.e(TAG, "连接文件服务器失败");
            onFailue(uploadEntity, ERROR_CODE_CONN_SERVER_FAILED);
            return;
        }

        String fileid = "";
        if (TextUtils.isEmpty(uploadEntity.getFileId())) {
            //文件还从来没有上传过
            // 上传一个0字节，获取一个fileid
            String result = null;
            try {
                result = client
                        .upload_appender_file1(new byte[]{}, uploadEntity.getExtName(), null);
                fileid = result;
                System.err.println("fileid: " + result);
                System.err.println("upload zero byte cost time "
                        + (System.currentTimeMillis() - start) / 1000.0);
            } catch (IOException e) {
                e.printStackTrace();
                onFailue(uploadEntity, ERROR_CODE_NETWORK_UNVALIBLE);
                return;
            } catch (MyException e) {
                onFailue(uploadEntity, ERROR_CODE_UPLOAD_FAILED);
                e.printStackTrace();
                return;
            }
            FLog.d(TAG, "开始上传文件 " + uploadEntity.getLocalPath());
            uploadEntity.setFileId(fileid);

            start = System.currentTimeMillis();


        } else {
            // 向文件服务器请求 获取服务器已经上传的文件大小
            // 对比本地文件大小是否一致
            FileInfo f = null;
            int fCount = 0;
            do {
                try {
                    f = client.get_file_info1(uploadEntity.getFileId());
                } catch (Exception e) {
                    onFailue(uploadEntity, ERROR_CODE_GET_FILE_INFO_FAILED);
                    e.printStackTrace();
                    return;
                }
                FLog.d(TAG, "获取服务器文件大小 " + f);
                fCount++;
                if (f == null) {
                    try {
                        Thread.sleep(2000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (fCount >= 20) {
                        onFailue(uploadEntity, ERROR_CODE_GET_FILE_INFO_FAILED);
                        return;
                    }
                }

            } while (f == null);

            fCount = 0;
            uploadEntity.setAddedSize(f.getFileSize());
            uploadEntity.setProgress((int) (uploadEntity.getAddedSize() * 100.0 / uploadEntity.getTotalSize()));
            if (f.getFileSize() == uploadEntity.getTotalSize() && f.getFileSize() != 0) {
                FLog.d(TAG, "服务器已经存在完整的此文件，秒传成功");
                //已经上传完成
                onSuccess(uploadEntity);
                return;
            } else {
                FLog.d(TAG, "断点续传文件 " + uploadEntity.toString());
            }
        }


        long size = uploadEntity.getAddedSize();
        // long size = upload_file(setResult);
        // System.err.println("uoloaded size "+size);
        // System.err.println("uoload cost time "+(System.currentTimeMillis()-start)/1000.0);

        long temp = System.currentTimeMillis();

        while ((System.currentTimeMillis() - temp) / 1000 < 60) {


            //因异常中断服务端会抹去追加的部分，需等待服务端抹去后再上传
            while (!compare(uploadEntity.getFileId(), size)) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }


            size = upload_append(uploadEntity);

            if (!FlagUploading) {
                Log.w(TAG, "上传被用户主动中止");
                onPause(uploadEntity);
                return;
            }

            System.err.println("upload_file5_3 size " + size);
            if (size == 0) {
                onFailue(uploadEntity, ERROR_CODE_NETWORK_UNVALIBLE);
                return;
            }

            try {
                Thread.sleep(1000 * 2);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            FileInfo fInfo = null;
            try {
                fInfo = client.get_file_info1(uploadEntity.getFileId());
            } catch (Exception e) {
                e.printStackTrace();
                onFailue(uploadEntity, ERROR_CODE_GET_FILE_INFO_FAILED);
                return;
            }

            if (fInfo != null && fInfo.getFileSize() != 0) {
                FLog.d(TAG, "本地文件大小：" + uploadEntity.getTotalSize() + " 云端文件大小：" + fInfo.getFileSize());
                onSuccess(uploadEntity);
                return;
            } else {
                //文件未上传完成
                Log.e(TAG, "文件上传成功后，无法获取到文件");
                onFailue(uploadEntity, ERROR_CODE_UPLOAD_FAILED);
                return;
            }

        }

    }


    /**
     * 比较本地和服务器的文件大小是否相等，如果不相等则代表服务端在异常中断后还未恢复到异常中断之前
     *
     * @param fileid
     * @param size
     * @return
     */
    public boolean compare(String fileid, long size) {
        try {
            FileInfo f = client.get_file_info1(fileid);
            long couldSize = f == null ? 0 : f.getFileSize();
            System.err.println("服务端文件大小为" + couldSize + ",本地记录已上传文件大小为:" + size);
            return couldSize == size;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 上传文件 追加
     *
     * @param upload
     * @return
     */
    @SuppressWarnings("resource")
    public long upload_append(UploadBean upload) {
        long skipsize = upload.getAddedSize();//已经上传的文件长度
        long length = new File(upload.getLocalPath()).length();//本地文件总长度
        if (skipsize >= length) {
            return length;
        }
        int size = 0;


        long localFileSize = new File(upload.getLocalPath()).length();
        int section_size;

        if (localFileSize > 20 * 1024 * 1024) { //20M以上
            section_size = (int) (localFileSize * 1.0 / 100);
        } else if (localFileSize > 2 * 1024 * 1024) { // 2M以上
            section_size = (int) (localFileSize * 1.0 / 10);
        } else { //2M以下
            section_size = (int) localFileSize;
        }


        byte[] buff = new byte[section_size];
        InputStream is = null;
        try {
            is = new FileInputStream(upload.getLocalPath());
            is.skip(skipsize);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return 0;
        } catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        System.err.println("file size: " + length);
        long start = System.currentTimeMillis();
        while (skipsize < length && FlagUploading) {
            int readcount = 0;
            try {
                readcount = is.read(buff, 0,
                        (length - skipsize) < buff.length ? (int) (length - skipsize)
                                : buff.length);
            } catch (IOException e) {
                e.printStackTrace();
                return 0;
            }
            int count = 0;
            while (true) {
                int result = -1;
                try {
                    byte[] newbuffer;
                    if (readcount < buff.length) {
                        newbuffer = new byte[readcount];
                        System.arraycopy(buff, 0, newbuffer, 0, readcount);
                        result = client.append_file1(upload.getFileId(),
                                newbuffer);

                    } else {
                        result = client.append_file1(upload.getFileId(),
                                buff);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
                count++;
                FLog.d(TAG, "此段文件流上传结果 setResult = " + result);
                if (result == 0) {
                    break;
                }
                if (count >= 1) {
                    return skipsize;
                }
            }
            size += readcount;
            skipsize += readcount;
            uploadEntity.setAddedSize(skipsize);
            uploadEntity.setProgress((int) (uploadEntity.getAddedSize() * 100.0 / uploadEntity.getTotalSize()));
            onProgress(uploadEntity);
            System.err.println("upload " + size + " byte cost time "
                    + (System.currentTimeMillis() - start) / 1000.0 + ",upload total " + skipsize);
        }
        return length;
    }




/*
------------------------------------------------------------------------------------
 */
    /**
     * 存储服务器地址
     */
    private InetSocketAddress StorageAddr;

    public InetSocketAddress getStorageAddr() {
        return StorageAddr;
    }

    public void setStorageAddr(InetSocketAddress storageAddr) {
        StorageAddr = storageAddr;
    }

    public void initClientGlobal(String ip, int port) {
        ClientGlobal.g_connect_timeout = 15000;
        ClientGlobal.g_anti_steal_token = false;
        ClientGlobal.g_charset = "UTF-8";
        ClientGlobal.g_network_timeout = 30000;
        ClientGlobal.g_secret_key = "FastDFS1234567890";
        ClientGlobal.g_tracker_http_port = 3108;
        // ClientGlobal.g_tracker_group = new TrackerGroup(new
        // InetSocketAddress[] { new InetSocketAddress(ip, port) });
        this.trackerGroup = new TrackerGroup(new InetSocketAddress[]{new InetSocketAddress(ip, port)});
    }

    /**
     * 获取存储客户端连接
     *
     * @return 存储客户端
     * @throws IOException
     */
    public StorageClient1 getStorageClient1() throws IOException {

        StorageClient1 client1 = null;

        TrackerClient tc = new TrackerClient(trackerGroup);

        // 建立tracker server 的连接
        if (tc == null) {
            return null;
        }
        trackerServer = tc.getConnection();

        // 建立存储服务器的连接
        storageServer = tc.getStoreStorage(trackerServer);
        if (storageServer != null) {
            // FLog.i(TAG, "storageServer IPS = " +
            // storageServer.getInetSocketAddress());
            setStorageAddr(storageServer.getInetSocketAddress());
        } else {
            return null;
        }

        // 建立存储客户端
        client1 = new StorageClient1(trackerServer, storageServer);

        return client1;
    }

    void closeClient1() {
        try {
            if (storageServer != null) {
                storageServer.getSocket().getOutputStream().flush();
                storageServer.close();
            }
            if (trackerServer != null) {
                trackerServer.getSocket().getOutputStream().flush();
                trackerServer.close();

            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
