package cn.com.startai.fssdk.event;

import android.os.Handler;
import android.os.Looper;

import java.util.ArrayList;

import cn.com.startai.fssdk.FSDownloadCallback;
import cn.com.startai.fssdk.FSUploadCallback;
import cn.com.startai.fssdk.db.entity.DownloadBean;
import cn.com.startai.fssdk.db.entity.UploadBean;

public class FSEventDispatcher {

    Handler handler = new Handler(Looper.getMainLooper());
    private static FSEventDispatcher instance;

    private static final String TAG = FSEventDispatcher.class.getName();

    private ArrayList<FSDownloadCallback> downloadCallbacks;
    private ArrayList<FSUploadCallback> uploadCallbacks;


    private FSEventDispatcher() {
        this.downloadCallbacks = null;
        this.uploadCallbacks = null;
    }

    public static FSEventDispatcher getInstance() {

        if (instance == null) {
            instance = new FSEventDispatcher();
        }
        return instance;
    }

    /**
     * 注册下载事件观察者
     * @param fsDownloadCallback
     */
    public void registerDownloadCallback(FSDownloadCallback fsDownloadCallback) {

        synchronized (this) {
            if (null != fsDownloadCallback) {
                if (null == this.downloadCallbacks) {
                    this.downloadCallbacks = new ArrayList<>();
                }
                this.downloadCallbacks.add(fsDownloadCallback);
            }
        }

    }

    /**
     * 注册上传事件观察者
     * @param fsUploadCallback
     */
    public void registerUploadCallback(FSUploadCallback fsUploadCallback) {

        synchronized (this) {
            if (null != fsUploadCallback) {
                if (null == this.uploadCallbacks) {
                    this.uploadCallbacks = new ArrayList<>();
                }
                this.uploadCallbacks.add(fsUploadCallback);
            }
        }

    }

    /**
     * 取消注册上传事件观察者
     * @param callback
     */
    public void unRegisterUploadCallback(FSUploadCallback callback) {
        synchronized (this) {
            if (null != callback && null != this.uploadCallbacks && 0 < this.uploadCallbacks.size()) {
                this.uploadCallbacks.remove(callback);
            }
        }
    }

    /**
     * 取消注册下载事件观察者
     * @param callback
     */
    public void unRegisterDownloadCallback(FSDownloadCallback callback) {
        synchronized (this) {
            if (null != callback && null != this.downloadCallbacks && 0 < this.downloadCallbacks.size()) {
                this.downloadCallbacks.remove(callback);
            }
        }
    }

    public void onDownloadProgress(DownloadBean downloadBean) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onProgress(downloadBean);
            }
        }
    }

    public void onDownloadStart(DownloadBean downloadBean) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onStart(downloadBean);
            }
        }
    }

    public void onDownloadWaiting(DownloadBean downloadBean) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onWaiting(downloadBean);
            }
        }
    }

    public void onDownloadFailure(DownloadBean downloadBean, int errorCode) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onFailure(downloadBean, errorCode);
            }
        }
    }

    public void onDownloadSuccess(DownloadBean downloadBean) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onSuccess(downloadBean);
            }
        }
    }

    public void onDownloadPause(DownloadBean downloadBean) {
        if (downloadCallbacks != null) {
            for (final FSDownloadCallback listener : downloadCallbacks) {
                listener.onPause(downloadBean);
            }
        }
    }

    public void onUploadProgress(UploadBean uploadBean) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onProgress(uploadBean);
            }
        }
    }

    public void onUploadStart(UploadBean uploadBean) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onStart(uploadBean);
            }
        }
    }

    public void onUploadWaiting(UploadBean uploadBean) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onWaiting(uploadBean);
            }
        }
    }

    public void onUploadFailure(UploadBean uploadBean, int errorCode) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onFailure(uploadBean, errorCode);
            }
        }
    }

    public void onUploadSuccess(UploadBean uploadBean) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onSuccess(uploadBean);
            }
        }
    }

    public void onUploadPause(UploadBean uploadBean) {
        if (uploadCallbacks != null) {
            for (final FSUploadCallback listener : uploadCallbacks) {
                listener.onPause(uploadBean);
            }
        }
    }


}