package cn.com.startai.fssdk.download.http;

import android.util.Log;

import org.xutils.common.Callback;
import org.xutils.http.RequestParams;
import org.xutils.http.app.HttpRetryHandler;
import org.xutils.x;

import java.io.File;

import cn.com.startai.fssdk.BaseDownloader;
import cn.com.startai.fssdk.DownloadParam;
import cn.com.startai.fssdk.FSDownloadCallback;
import cn.com.startai.fssdk.StartaiDownloaderManager;
import cn.com.startai.fssdk.db.FDBManager;
import cn.com.startai.fssdk.db.entity.DownloadBean;
import cn.com.startai.fssdk.event.FSEventDispatcher;
import cn.com.startai.fssdk.utils.FFileUtils;
import cn.com.startai.fssdk.utils.FLog;


/**
 * http下载器
 * Created by Robin on 2017/9/15.
 * 419109715@qq.com 彬影
 */

public class StartaiHttpDownloader extends BaseDownloader implements Runnable {

    private String TAG;
    private FSDownloadCallback callback;

    private Callback.Cancelable post;
    private int lastProgress; //记录上一次的进度 如果下载了 一段数据后 带是一样的 百分比就不更新进度

    private DownloadBean download;


    public StartaiHttpDownloader(DownloadBean entity, FSDownloadCallback callback) {

        TAG = this.getClass().getSimpleName();
        this.download = entity;
        this.callback = callback;
    }


    @Override
    public DownloadBean getDownloadBean() {
        return this.download;
    }

    @Override
    public int getDownloadStatus() {
        return download.getStatus();
    }

    @Override
    public void stopDownload() {
        if (post != null && !post.isCancelled()) {
            post.cancel();
        }
    }


    @Override
    public void onProgress(final DownloadBean downloadBean) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(1);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);
                if (null != callback) {

                    callback.onProgress(downloadBean);
                }else{
                    FSEventDispatcher.getInstance().onDownloadProgress(downloadBean);
                }

            }
        });
    }

    @Override
    public void onWaiting(final DownloadBean downloadBean) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(3);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);

                if (null != callback) {

                    callback.onWaiting(downloadBean);
                }else{
                    FSEventDispatcher.getInstance().onDownloadWaiting(downloadBean);
                }

            }
        });
    }

    @Override
    public void onStart(final DownloadBean downloadBean) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(1);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);
                if (null != callback) {

                    callback.onStart(downloadBean);
                }else{
                    FSEventDispatcher.getInstance().onDownloadStart(downloadBean);
                }

            }
        });
    }

    @Override
    public void onSuccess(final DownloadBean downloadBean) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(2);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);
//                FFileUtils.rename(downloadBean.getLocalPath() + ".tmp", downloadBean.getFileName());
                if (null != callback) {

                    callback.onSuccess(downloadBean);
                }else{
                    FSEventDispatcher.getInstance().onDownloadSuccess(downloadBean);
                }
                StartaiDownloaderManager.getInstance().toDownload();
            }
        });
    }

    @Override
    public void onFailue(final DownloadBean downloadBean, final int errorCode) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(4);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);
                if (null != callback) {

                    callback.onFailure(downloadBean, errorCode);
                }else{
                    FSEventDispatcher.getInstance().onDownloadFailure(downloadBean,errorCode);
                }
                StartaiDownloaderManager.getInstance().toDownload();

            }
        });
    }

    @Override
    public void onPause(final DownloadBean downloadBean) {
        StartaiDownloaderManager.getInstance().runInTHread(new Runnable() {
            @Override
            public void run() {
                downloadBean.setStatus(0);
                FDBManager.getInstance().addOrUpdateDownloadBean(downloadBean);
                if (null != callback) {

                    callback.onPause(downloadBean);
                }else{
                    FSEventDispatcher.getInstance().onDownloadPause(downloadBean);
                }
                StartaiDownloaderManager.getInstance().toDownload();

            }
        });
    }

    @Override
    public void run() {

        String url = download.getUrl();


        Log.i(TAG, "url = " + url);
        RequestParams params = new RequestParams(url);
        params.setSaveFilePath(download.getLocalPath());
        params.setAutoResume(true);//设置是否在下载是自动断点续传

        params.setReadTimeout(30000);
        params.setConnectTimeout(15000);
        params.setMaxRetryCount(DownloadParam.retryTimes);
        params.setHttpRetryHandler(new HttpRetryHandler());

        post = x.http().get(params, new Callback.ProgressCallback<File>() {
            @Override
            public void onSuccess(File result) {
                Log.i(TAG, "onSuccess " + result.getAbsolutePath());
                if (download.getProgress() == 100) {
                    FFileUtils.rename(result, download.getFileName());
                    StartaiHttpDownloader.this.onSuccess(download);
                }
            }

            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                String stackTraceString = Log.getStackTraceString(ex);
                ex.printStackTrace();
//                Log.i(TAG, "onError "+errorMsg);
//                L.saveLog(context, (Exception) ex);
                FLog.d(TAG, "retyr times = " + DownloadParam.retryTimes);
                FLog.e(TAG, "stackTraceString = " + stackTraceString);
                onFailue(download, ERROR_CODE_NETWORK_UNVALIBLE);
            }

            @Override
            public void onCancelled(CancelledException cex) {
                FLog.d(TAG, "onCancelled");
                onPause(download);
            }


            @Override
            public void onFinished() {
                FLog.d(TAG, "onFinished");

            }

            //网络请求之前回调
            @Override
            public void onWaiting() {
                FLog.d(TAG, "onWaiting");
            }

            //网络请求开始的时候回调
            @Override
            public void onStarted() {
                FLog.d(TAG, "onStarted");
            }

            //下载的时候不断回调的方法
            @Override
            public void onLoading(long total, long current, boolean isDownloading) {

                //当前进度和文件总大小
                FLog.d(TAG, "onLoading current：" + current + "，total：" + total);
                download.setTotalSize(total);


                download.setAddedSize(current);
                download.setProgress((int) (download.getAddedSize() * 100.0 / download.getTotalSize()));


                // 每当缓存下载量到 1%的时候 更新进度并清空缓存重新开始缓存
                if (download.getTotalSize() < 1024 * 1024 * 2) {
                    //如果是2M以下的文件直接下载 不回调进度
                } else if (download.getTotalSize() < 1024 * 1024 * 20) {
                    //如果是20M以下 每10%回进度
                    if (download.getProgress() % 10 == 0 && download.getProgress() != 100) {
                        if (lastProgress != download.getProgress()) {
                            onProgress(download);
                            lastProgress = download.getProgress();
                        }
                    }

                } else {
                    //如果是20M以上 每 1%回进度
                    if (lastProgress != download.getProgress() && download.getProgress() != 100) {
                        onProgress(download);
                        lastProgress = download.getProgress();
                    }
                }
            }
        });


    }
}
