package cn.com.startai.fssdk.download.dfs;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

/**
* Copyright (C) 2008 Happy Fish / YuQing
*
* FastDFS Java Client may be copied only under the terms of the GNU Lesser
* General Public License (LGPL).
* Please visit the FastDFS Home Page http://www.csource.org/ for more detail.
**/
public class ProtoCommon {

	/**
	* get token for file URL
	* @param remoteFilename the filename return by FastDFS server
	* @param ts unix timestamp, unit: second
	* @param secretKey the secret key
	* @return token string
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	*/
	 public static String getToken(String remoteFilename, long ts, String secretKey) throws UnsupportedEncodingException, NoSuchAlgorithmException {
	 	byte[] bsFilename = remoteFilename.getBytes("UTF-8");
	 	byte[] bsKey = secretKey.getBytes("UTF-8");
	 	byte[] bsTimestamp = (new Long(ts)).toString().getBytes("UTF-8");
	 	
	 	byte[] buff = new byte[bsFilename.length + bsKey.length + bsTimestamp.length];
	 	System.arraycopy(bsFilename, 0, buff, 0, bsFilename.length);
	 	System.arraycopy(bsKey, 0, buff, bsFilename.length, bsKey.length);
	 	System.arraycopy(bsTimestamp, 0, buff, bsFilename.length + bsKey.length, bsTimestamp.length);
	 	
	 	return md5(buff);
	 }
	 
	 /**
	 * md5 function
	 * @param source the input buffer
	 * @return md5 string
	 */
	 public static String md5(byte[] source) throws NoSuchAlgorithmException {
	  	char hexDigits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd',  'e', 'f'};
	    java.security.MessageDigest md = java.security.MessageDigest.getInstance("MD5");
	    md.update(source);
	    byte tmp[] = md.digest();
	    char str[] = new char[32];
	    int k = 0;
	    for (int i = 0; i < 16; i++)
	    {
	     str[k++] = hexDigits[tmp[i] >>> 4 & 0xf];
	     str[k++] = hexDigits[tmp[i] & 0xf];
	    }
	    
	  	return new String(str);
	 }
	 
	 public static void main(String[] args) {
		 try {
			long lts = System.currentTimeMillis()/1000L;
			String remoteFilename = "M00/00/00/wKgB2ViEMZOAeE4rAAF1DzcVmmk051.jpg";
			System.out.println("lts="+lts);
			String token = ProtoCommon.getToken(remoteFilename, lts, "FastDFS1234567890");
			System.out.println("token="+token);
			System.out.println("httpurl=http://192.168.1.217/group1/"+remoteFilename+"?token="+token+"&ts="+lts);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
	}
}
