package cn.com.startai.fssdk.db.entity;

import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

/**
 * 文件上传实体
 * Created by Robin on 2017-07-28.
 * 419109715@qq.com 彬影
 */
@Table(name = "upload")
public class UploadBean {


    public static final String TABLE_NAME = "upload";

    @Column(name = "_id", isId = true)
    private int _id;

    @Column(name = "httpDownloadUrl")
    private String httpDownloadUrl;
    public static final String FIELD_HTTPDOWNLOAD_URL = "httpDownloadUrl";


    @Column(name = "status")
    private int status; //上传状态  0暂停 1上传中 2上传完成 3暂停中等待上传 4 暂停中上传失败
    public static final String FIELD_STATUS = "status";

    @Column(name = "extName")
    private String extName;
    public static final String FIELD_EXTNAME = "extName";

    @Column(name = "localPath")
    private String localPath;
    public static final String FIELD_LOCALPATH = "localPath";


    @Column(name = "addedSize")
    private long addedSize;
    public static final String FIELD_ADDEDSIZE = "addedSize";

    @Column(name = "totalSize")
    private long totalSize;
    public static final String FIELD_TOTALSIZE = "totalSize";

    @Column(name = "progress")
    private int progress;
    public static final String FIELD_PROGRESS = "progress";

    @Column(name = "updateTime")
    private long updateTime;
    public static final String FIELD_UPDATETIME = "updateTime";

    @Column(name = "fileName")
    private String fileName;
    public static final String FIELD_FILENAME = "fileName";

    @Column(name = "fileId")
    private String fileId;
    public static final String FILED_FILEID = "fileId";

    @Column(name = "uploadIP")
    private String uploadIP;//文件上传的ip
    public static final String FILED_UPLOADIP = "uploadIP";

    @Column(name = "uploadPort")
    private int uploadPort;//文件上传的端口
    public static final String FILED_UPLOADPORT = "uploadPort";

    @Column(name = "protocol")
    private String protocol; //协议 tcp  http
    public static final String FILED_PROTOCOL = "protocol";

    @Override
    public String toString() {
        return "UploadBean{" +
                "_id=" + _id +
                ", httpDownloadUrl='" + httpDownloadUrl + '\'' +
                ", status=" + status +
                ", extName='" + extName + '\'' +
                ", localPath='" + localPath + '\'' +
                ", addedSize=" + addedSize +
                ", totalSize=" + totalSize +
                ", progress=" + progress +
                ", updateTime=" + updateTime +
                ", fileName='" + fileName + '\'' +
                ", fileId='" + fileId + '\'' +
                ", uploadIP='" + uploadIP + '\'' +
                ", uploadPort=" + uploadPort +
                ", protocol='" + protocol + '\'' +
                '}';
    }

    private UploadBean(Builder builder) {
        setHttpDownloadUrl(builder.httpDownloadUrl);
        setStatus(builder.status);
        setExtName(builder.extName);
        setLocalPath(builder.localPath);
        setAddedSize(builder.addedSize);
        setTotalSize(builder.totalSize);
        setProgress(builder.progress);
        setUpdateTime(builder.updateTime);
        setFileName(builder.fileName);
        setFileId(builder.fileId);
        setUploadIP(builder.uploadIP);
        setUploadPort(builder.uploadPort);
        setProtocol(builder.protocol);
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUploadIP() {
        return uploadIP;
    }

    public void setUploadIP(String uploadIP) {
        this.uploadIP = uploadIP;
    }

    public int getUploadPort() {
        return uploadPort;
    }

    public void setUploadPort(int uploadPort) {
        this.uploadPort = uploadPort;
    }

    public String getHttpDownloadUrl() {
        return httpDownloadUrl;
    }


    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public UploadBean() {
    }

    public int get_id() {
        return _id;
    }

    public void set_id(int _id) {
        this._id = _id;
    }


    public void setHttpDownloadUrl(String httpDownloadUrl) {
        this.httpDownloadUrl = httpDownloadUrl;
    }


    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }


    public String getExtName() {
        return extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }


    public String getLocalPath() {
        return localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }


    public long getAddedSize() {
        return addedSize;
    }

    public void setAddedSize(long addedSize) {
        this.addedSize = addedSize;
    }


    public long getTotalSize() {
        return totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }


    public int getProgress() {
        return progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }


    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static final class Builder {
        private String httpDownloadUrl;
        private int status;
        private String extName;
        private String localPath;
        private long addedSize;
        private long totalSize;
        private int progress;
        private long updateTime;
        private String fileName;
        private String fileId;
        private String uploadIP;
        private int uploadPort;
        private String protocol;

        public Builder() {
        }

        public Builder httpDownloadUrl(String val) {
            httpDownloadUrl = val;
            return this;
        }

        public Builder status(int val) {
            status = val;
            return this;
        }

        public Builder extName(String val) {
            extName = val;
            return this;
        }

        public Builder localPath(String val) {
            localPath = val;
            return this;
        }

        public Builder addedSize(long val) {
            addedSize = val;
            return this;
        }

        public Builder totalSize(long val) {
            totalSize = val;
            return this;
        }

        public Builder progress(int val) {
            progress = val;
            return this;
        }

        public Builder updateTime(long val) {
            updateTime = val;
            return this;
        }

        public Builder fileName(String val) {
            fileName = val;
            return this;
        }

        public Builder fileId(String val) {
            fileId = val;
            return this;
        }

        public Builder uploadIP(String val) {
            uploadIP = val;
            return this;
        }

        public Builder uploadPort(int val) {
            uploadPort = val;
            return this;
        }

        public Builder protocol(String val) {
            protocol = val;
            return this;
        }

        public UploadBean build() {
            return new UploadBean(this);
        }
    }
}
