package cn.com.startai.fssdk.db.entity;

import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

/**
 * 文件下载实体
 * Created by Robin on 2017-07-28.
 * 419109715@qq.com 彬影
 */
@Table(name = "download")
public class DownloadBean {

    public static final String TABLE_NAME = "download";

    @Column(name = "_id", isId = true)
    private int _id;

    @Column(name = "url")
    private String url;
    public static final String FIELD_URL = "url";


    @Column(name = "status")
    private int status; //0：暂停中 1：下载中 2：下载完成 3：暂停中待下载 4：暂停中下载失败
    public static final String FIELD_STATUS = "status";


    @Column(name = "extName")
    private String extName;
    public static final String FIELD_EXTNAME = "extName";

    @Column(name = "localPath")
    private String localPath;
    public static final String FIELD_LOCALPATH = "localPath";


    @Column(name = "addedSize")
    private long addedSize;
    public static final String FIELD_ADDEDSIZE = "addedSize";

    @Column(name = "totalSize")
    private long totalSize;
    public static final String FIELD_TOTALSIZE = "totalSize";

    @Column(name = "progress")
    private int progress;
    public static final String FIELD_PROGRESS = "progress";


    @Column(name = "updateTime")
    private long updateTime;
    public static final String FIELD_UPDATETIME = "updateTime";

    @Column(name = "fileName")
    private String fileName;
    public static final String FIELD_FILENAME = "fileName";

    @Column(name = "fileId")
    private String fileId;
    public static final String FILED_FID = "fileId";

    @Column(name = "protocol")
    private String protocol; //协议 tcp  http
    public static final String FILED_PROTOCOL = "protocol";

    @Override
    public String toString() {
        return "DownloadBean{" +
                "_id=" + _id +
                ", url='" + url + '\'' +
                ", status=" + status +
                ", extName='" + extName + '\'' +
                ", localPath='" + localPath + '\'' +
                ", addedSize=" + addedSize +
                ", totalSize=" + totalSize +
                ", progress=" + progress +
                ", updateTime=" + updateTime +
                ", fileName='" + fileName + '\'' +
                ", fileId='" + fileId + '\'' +
                ", protocol='" + protocol + '\'' +
                '}';
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public DownloadBean() {
    }

    public DownloadBean(int _id, String url, int status, String extName, String localPath, long addedSize, long totalSize, int progress, long updateTime, String fileName, String fileId) {
        this._id = _id;
        this.url = url;
        this.status = status;
        this.extName = extName;
        this.localPath = localPath;
        this.addedSize = addedSize;
        this.totalSize = totalSize;
        this.progress = progress;
        this.updateTime = updateTime;
        this.fileName = fileName;
        this.fileId = this.fileId;
    }

    private DownloadBean(Builder builder) {
        setUrl(builder.url);
        setStatus(builder.status);
        setExtName(builder.extName);
        setLocalPath(builder.localPath);
        setAddedSize(builder.addedSize);
        setTotalSize(builder.totalSize);
        setProgress(builder.progress);
        setUpdateTime(builder.updateTime);
        setFileName(builder.fileName);
        setFileId(builder.fid);
    }


    public int get_id() {
        return _id;
    }

    public void set_id(int _id) {
        this._id = _id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }


    public String getExtName() {
        return extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }


    public String getLocalPath() {
        return localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }


    public long getAddedSize() {
        return addedSize;
    }

    public void setAddedSize(long addedSize) {
        this.addedSize = addedSize;
    }


    public long getTotalSize() {
        return totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }


    public int getProgress() {
        return progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }


    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }


    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {

        this.fileId = fileId;
    }

    public static final class Builder {
        private String url;
        private int status;
        private String extName;
        private String localPath;
        private long addedSize;
        private long totalSize;
        private int progress;
        private long updateTime;
        private String fileName;
        private String fid;

        public Builder() {
        }

        public Builder url(String val) {
            url = val;
            return this;
        }

        public Builder status(int val) {
            status = val;
            return this;
        }

        public Builder extName(String val) {
            extName = val;
            return this;
        }

        public Builder localPath(String val) {
            localPath = val;
            return this;
        }

        public Builder addedSize(long val) {
            addedSize = val;
            return this;
        }

        public Builder totalSize(long val) {
            totalSize = val;
            return this;
        }

        public Builder progress(int val) {
            progress = val;
            return this;
        }

        public Builder updateTime(long val) {
            updateTime = val;
            return this;
        }

        public Builder fileName(String val) {
            fileName = val;
            return this;
        }

        public Builder Fid(String val) {
            fid = val;
            return this;
        }

        public DownloadBean build() {
            return new DownloadBean(this);
        }
    }
}
