package cn.com.startai.fssdk.db;


import org.xutils.DbManager;
import org.xutils.common.util.KeyValue;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.ex.DbException;
import org.xutils.x;

import java.io.FileReader;
import java.util.ArrayList;

import cn.com.startai.fssdk.db.entity.DownloadBean;
import cn.com.startai.fssdk.db.entity.UploadBean;
import cn.com.startai.fssdk.utils.FLog;


/**
 * Created by Robin on 2017/8/17.
 * 419109715@qq.com 彬影
 */
public class FDBManager {


    private static FDBManager instance;
    private DbManager.DaoConfig daoConfig;
    private static DbManager db;

    private final String DB_NAME = "fastdfs.db";
    private static final int VERSION = 6;
    private static String TAG = "db";


    private FDBManager() {
        daoConfig = new DbManager.DaoConfig()
                .setDbName(DB_NAME)
                .setDbVersion(VERSION)
                .setAllowTransaction(true)
                .setDbOpenListener(new DbManager.DbOpenListener() {
                    @Override
                    public void onDbOpened(DbManager db) {
                        db.getDatabase().enableWriteAheadLogging();
                        FLog.d(TAG, "数据库已经打开 name = " + DB_NAME + " verison = " + VERSION);
                    }
                })
                .setDbUpgradeListener(new DbManager.DbUpgradeListener() {
                    @Override
                    public void onUpgrade(DbManager db, int oldVersion, int newVersion) {
                        //数据库升级操作
                        FLog.d(TAG, "数据库升级" + oldVersion + " ==> " + newVersion);

                        switch (oldVersion) {

                            default:
                                break;

                        }

                    }
                });
        db = x.getDb(daoConfig);

    }

    public synchronized DbManager getDB() {
        return db;
    }

    public static FDBManager getInstance() {
        if (instance == null) {
            instance = new FDBManager();
        }
        return instance;
    }


    public void deleteAllDownload() {
        try {
            db.delete(DownloadBean.class);
        } catch (DbException e) {
            e.printStackTrace();
        }

    }

    /**
     * 重置下载状态
     */
    public void resetDownloadDB() {
        try {
            db.update(DownloadBean.class,
                    WhereBuilder.b(DownloadBean.FIELD_STATUS, "=", 1)
                            .or(DownloadBean.FIELD_STATUS, "=", 3),
                    new KeyValue(DownloadBean.FIELD_STATUS, 0));
        } catch (DbException e) {
            e.printStackTrace();
        }
    }

    /**
     * 重置上传状态
     */
    public void resetUploadDB() {
        try {
            db.update(UploadBean.class,
                    WhereBuilder.b(UploadBean.FIELD_STATUS, "=", 1)
                            .or(UploadBean.FIELD_STATUS, "=", 3),
                    new KeyValue(UploadBean.FIELD_STATUS, 0));
        } catch (DbException e) {
            e.printStackTrace();
        }
    }

    public void deleteAllUpload() {
        try {
            db.delete(UploadBean.class);
        } catch (DbException e) {
            e.printStackTrace();
        }

    }

    /**
     * 添加或更新
     *
     * @param downloadBean
     */
    public void addOrUpdateDownloadBean(DownloadBean downloadBean) {
        try {
            DownloadBean first = db.selector(DownloadBean.class).where(DownloadBean.FIELD_URL, "=", downloadBean.getUrl()).findFirst();

            downloadBean.setUpdateTime(System.currentTimeMillis());
            if (first == null) {
                db.save(downloadBean);
            } else {
                downloadBean.set_id(first.get_id());
                db.update(downloadBean);
            }
        } catch (DbException e) {
            e.printStackTrace();
        }
    }

    /**
     * 查询所有
     *
     * @return
     */
    public ArrayList<DownloadBean> getAllDownloadBean() {

        ArrayList<DownloadBean> all = null;
        try {
            all = (ArrayList<DownloadBean>) db.findAll(DownloadBean.class);
        } catch (DbException e) {
            e.printStackTrace();

        }

        if (all == null) {
            all = new ArrayList<>();
        }
        return all;

    }

    /**
     * 查询所有
     *
     * @return
     */
    public ArrayList<DownloadBean> getAllUncompleteDownloadBean() {

        ArrayList<DownloadBean> all = null;
        try {
            all = (ArrayList<DownloadBean>) db.selector(DownloadBean.class).where(DownloadBean.FIELD_STATUS, "<>", 2).findAll();
        } catch (DbException e) {
            e.printStackTrace();

        }

        if (all == null) {
            all = new ArrayList<>();
        }
        return all;

    }


    /**
     * 查询 单个
     *
     * @return
     */
    public DownloadBean getDownloadBeanByUrl(String url) {
        DownloadBean first = null;
        try {
            first = db.selector(DownloadBean.class).where(WhereBuilder.b(DownloadBean.FIELD_URL, "=", url)).findFirst();
        } catch (DbException e) {
            e.printStackTrace();

        }
        return first;

    }

    /**
     * 查询
     *
     * @return
     */
    public long getDownloadingCount() {
        long first = 0;

        try {
            first = db.selector(DownloadBean.class).where(WhereBuilder.b(DownloadBean.FIELD_STATUS, "=", 1)).count();

        } catch (DbException e) {
            e.printStackTrace();

        }
        return first;

    }

    /**
     * 正在下载及等待下载的
     *
     * @return
     */
    public ArrayList<DownloadBean> getDownloadingAndWaiting() {
        ArrayList<DownloadBean> all = null;
        try {
            all = (ArrayList<DownloadBean>) db.selector(DownloadBean.class).where(WhereBuilder.b(DownloadBean.FIELD_STATUS, "=", 1).or(DownloadBean.FIELD_STATUS, "=", 3)).findAll();
        } catch (DbException e) {
            e.printStackTrace();

        }
        if (all == null) {
            all = new ArrayList<>();
        }
        return all;

    }

    /**
     * 查询 单个
     *
     * @return
     */
    public DownloadBean getDownloadBeanByStatus(int status) {
        DownloadBean first = null;
        try {
            first = db.selector(DownloadBean.class).where(WhereBuilder.b(DownloadBean.FIELD_STATUS, "=", status)).findFirst();
        } catch (DbException e) {
            e.printStackTrace();

        }
        return first;

    }

    /**
     * 删除
     */
    public void deleteDownloadBeanByUrl(String url) {

        try {
            db.delete(DownloadBean.class, WhereBuilder.b(DownloadBean.FIELD_URL, "=", url));
        } catch (DbException e) {
            e.printStackTrace();
        }

    }


    /**
     * 添加或更新
     *
     * @param uploadBean
     */
    public void addOrUpdateUploadBean(UploadBean uploadBean) {

        try {

            UploadBean first = db.selector(UploadBean.class).where(UploadBean.FIELD_LOCALPATH, "=", uploadBean.getLocalPath()).findFirst();
            uploadBean.setUpdateTime(System.currentTimeMillis());
            if (first == null) {
                db.save(uploadBean);
            } else {
                uploadBean.set_id(first.get_id());
                db.update(uploadBean);
            }
        } catch (DbException e) {
            e.printStackTrace();
        }
    }


    /**
     * 查询单个
     *
     * @param localPath
     * @return
     */
    public UploadBean getUploadBeanByLocalPath(String localPath) {
        UploadBean first = null;
        try {
            first = db.selector(UploadBean.class).where(UploadBean.FIELD_LOCALPATH, "=", localPath).findFirst();
        } catch (DbException e) {
            e.printStackTrace();
        }


        return first;
    }

    /**
     * 查询所有
     *
     * @return
     */
    public ArrayList<UploadBean> getAllUploadBean() {

        ArrayList<UploadBean> all = null;
        try {
            all = (ArrayList<UploadBean>) db.findAll(UploadBean.class);
        } catch (DbException e) {
            e.printStackTrace();

        }

        if (all == null) {
            all = new ArrayList<>();
        }
        return all;

    }


    /**
     * 查询所有未完成
     *
     * @return
     */
    public ArrayList<UploadBean> getAllUncompleteUploadBean() {

        ArrayList<UploadBean> all = null;
        try {
            all = (ArrayList<UploadBean>) db.selector(UploadBean.class).where(UploadBean.FIELD_STATUS, "<>", 2).findAll();
        } catch (DbException e) {
            e.printStackTrace();

        }

        if (all == null) {
            all = new ArrayList<>();
        }
        return all;

    }

    /**
     * 删除
     */
    public void deleteUploadBeanByLocalPath(String localPath) {

        try {
            db.delete(UploadBean.class, WhereBuilder.b(UploadBean.FIELD_LOCALPATH, "=", localPath));
        } catch (DbException e) {
            e.printStackTrace();
        }

    }

    /**
     * 查询
     *
     * @return
     */
    public long getUploadingCount() {
        long first = 0;
        try {
            first = db.selector(UploadBean.class).where(WhereBuilder.b(UploadBean.FIELD_STATUS, "=", 1)).count();

        } catch (DbException e) {
            e.printStackTrace();

        }
        return first;

    }


    /**
     * 查询 单个
     *
     * @return
     */
    public UploadBean getUploadBeanByStatus(int status) {
        UploadBean first = null;
        try {
            first = db.selector(UploadBean.class).where(WhereBuilder.b(UploadBean.FIELD_STATUS, "=", status)).findFirst();
        } catch (DbException e) {
            e.printStackTrace();

        }
        return first;

    }

}