package cn.com.startai.fssdk;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;

import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import cn.com.startai.fssdk.db.FDBManager;
import cn.com.startai.fssdk.db.entity.DownloadBean;
import cn.com.startai.fssdk.db.entity.UploadBean;
import cn.com.startai.fssdk.event.FSEventDispatcher;
import cn.com.startai.fssdk.upload.dfs.StartaiUploader;
import cn.com.startai.fssdk.utils.FFileUtils;
import cn.com.startai.fssdk.utils.FLog;
import cn.com.startai.fssdk.utils.FSConsts;
import cn.com.startai.fssdk.utils.FUtils;


public class StartaiUploaderManager {
    Handler mHandler;
    private static volatile StartaiUploaderManager singleton;
    private Context context;

    private HashMap<String, FSUploadCallback> callbacks = new HashMap<>();
    private boolean isInit;

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    HashMap<String, BaseUploader> maps = new HashMap<>();

    private String TAG = StartaiDownloaderManager.class.getSimpleName();

    static ExecutorService executorService;
    private boolean isStopAll;

    private StartaiUploaderManager() {
    }

    public void runInTHread(Runnable runnable) {
        mHandler.post(runnable);
    }

    public static StartaiUploaderManager getInstance() {
        if (singleton == null) {
            synchronized (StartaiUploaderManager.class) {
                if (singleton == null) {
                    singleton = new StartaiUploaderManager();
                }
            }
        }
        return singleton;
    }

    public void init(Application context, UploadInitParam param) {
        if (!isInit) {
            singleton.context = context;
            x.Ext.init(context);
            if (param != null) {

                int maxThread = param.getMaxThread();
                if (maxThread > 3) {
                    maxThread = 3;
                }
                if (maxThread < 1) {
                    maxThread = 1;
                }
                int retryTimes = param.getRetryTimes();
                if (retryTimes > 2) {
                    retryTimes = 2;
                }
                if (retryTimes < 0) {
                    retryTimes = 0;
                }
                UploadParam.maxThread = maxThread;
                UploadParam.retryTimes = retryTimes;
            }
            executorService = Executors.newFixedThreadPool(UploadParam.maxThread);
            HandlerThread ht = new HandlerThread(TAG);
            ht.start();
            singleton.mHandler = new Handler(ht.getLooper());
            getFDBManager().resetUploadDB();
            isInit = true;
        }
    }

    public FDBManager getFDBManager() {
        return FDBManager.getInstance();
    }

    /**
     * 暂停任务
     *
     * @param localPath
     */
    public void stopUploader(String localPath) {
        FLog.d(TAG, "stopUploader()");
        BaseUploader uploader = maps.remove(localPath);
        if (uploader != null) {
//            UploadBean uploadBean = uploader.getUploadBean();
//            uploadBean.setStatus(0);
//            getFDBManager().addOrUpdateUploadBean(uploadBean);
            uploader.stopUpload();
        }


    }

    /**
     * 删除任务
     *
     * @param localPath
     */
    public void clearUploader(String localPath) {
        FLog.d(TAG, "clearUploader()");
        stopUploader(localPath);

        getFDBManager().deleteUploadBeanByLocalPath(localPath);

    }

    /**
     * 暂停所有上传任务
     */
    public void stopAllUploader() {
        FLog.d(TAG, "stopAllUploader()");
        isStopAll = true;
        Collection<BaseUploader> values = maps.values();

        for (BaseUploader value : values) {
            if (value != null) {
                value.stopUpload();
            }
        }
        maps.clear();
        getFDBManager().resetUploadDB();

    }

    /**
     * 删除所有任务
     */
    public void clearAllUploader() {
        FLog.d(TAG, "clearAllUploader()");
        stopAllUploader();

        getFDBManager().deleteAllUpload();
    }

    /**
     * 开启所有上传任务
     */
    public void startAllUploader() {
        isStopAll = false;
        ArrayList<UploadBean> allUncompleteUploadBean = getFDBManager().getAllUncompleteUploadBean();

        for (UploadBean uploadBean : allUncompleteUploadBean) {
            uploadBean.setStatus(3);
            getFDBManager().addOrUpdateUploadBean(uploadBean);
            toUpload();
        }
    }



    /**
     * 获取当前正在上传的任务个数
     */
    public long getUploadTaskSize() {


        return FDBManager.getInstance().getUploadingCount();
    }


    /**
     * 开始上传
     *
     * @param uploadBean
     */
    public void startUpload(final UploadBean uploadBean, final FSUploadCallback callback) {
        isStopAll = false;

        runInTHread(new Runnable() {
            @Override
            public void run() {

                String localPath = uploadBean.getLocalPath();
                if (TextUtils.isEmpty(localPath) || !FFileUtils.isFileExists(localPath)) {
                    if (callback != null) {
                        uploadBean.setStatus(4);
                        getFDBManager().addOrUpdateUploadBean(uploadBean);
                        callback.onFailure(uploadBean, BaseUploader.ERROR_CODE_LOCAL_PATH_NOT_EXIT);
                    }else {
                        FSEventDispatcher.getInstance().onUploadFailure(uploadBean,BaseUploader.ERROR_CODE_LOCAL_PATH_NOT_EXIT);
                    }
                    return;
                }
                if (TextUtils.isEmpty(uploadBean.getProtocol())) {
                    uploadBean.setProtocol("tcp");
                } else if (!uploadBean.getProtocol().equals("tcp") && !uploadBean.getProtocol().equals("http")) {
                    uploadBean.setStatus(4);
                    getFDBManager().addOrUpdateUploadBean(uploadBean);
                    if (callback != null) {
                        callback.onFailure(uploadBean, BaseUploader.ERROR_CODE_UPLOAD_TYPE);
                    }else{
                       FSEventDispatcher.getInstance().onUploadFailure(uploadBean, BaseUploader.ERROR_CODE_UPLOAD_TYPE);
                    }
                    return;
                }

                callbacks.put(uploadBean.getLocalPath(), callback);

                UploadBean uploadBeanByLocalPath = getFDBManager().getUploadBeanByLocalPath(uploadBean.getLocalPath());

                if (uploadBeanByLocalPath != null) {
                    //曾经上传过此文件
                    FLog.d(TAG, "曾经上传过此文件");
                    //文件是否已经上传完成
                    if (uploadBeanByLocalPath.getAddedSize() == uploadBeanByLocalPath.getTotalSize() && uploadBeanByLocalPath.getAddedSize() != 0) {
                        FLog.d(TAG, "文件已经正确上传完成");
                        uploadBeanByLocalPath.setStatus(2);
                        FDBManager.getInstance().addOrUpdateUploadBean(uploadBeanByLocalPath);
                        if (callback != null) {
                            callback.onSuccess(uploadBeanByLocalPath);
                        }else{
                            FSEventDispatcher.getInstance().onUploadSuccess(uploadBeanByLocalPath);
                        }
                        return;
                    }

                    FLog.d(TAG, "文件没有上传完成");
                    //此文件是否正在上传
                    if (uploadBeanByLocalPath.getStatus() == 1) {
                        //文件正在上传不做处理
                        FLog.d(TAG, "文件正在上传不做处理");
                        return;
                    }

                    uploadBeanByLocalPath.setStatus(3);
                    FDBManager.getInstance().addOrUpdateUploadBean(uploadBeanByLocalPath);
                    if (callback != null) {
                        callback.onWaiting(uploadBeanByLocalPath);
                    }else{
                        FSEventDispatcher.getInstance().onUploadWaiting(uploadBeanByLocalPath);
                    }

                } else {
                    //没有上传过此文件
                    FLog.d(TAG, "没有上传过此文件");
                    if (TextUtils.isEmpty(uploadBean.getExtName())) {
                        uploadBean.setExtName(FUtils.getExtensionName(uploadBean.getLocalPath()));
                    }
                    if (uploadBean.getTotalSize() == 0) {
                        uploadBean.setTotalSize(new File(uploadBean.getLocalPath()).length());
                    }
                    if (TextUtils.isEmpty(uploadBean.getUploadIP())) {
                        uploadBean.setUploadIP(FSConsts.FS_IP);
                    }
                    if (uploadBean.getUploadPort() == 0) {
                        uploadBean.setUploadPort(FSConsts.FS_PORT);
                    }
                    if (TextUtils.isEmpty(uploadBean.getFileName())) {
                        uploadBean.setFileName(FFileUtils.getFileName(uploadBean.getLocalPath()));
                    }

                    uploadBean.setStatus(3);
                    uploadBean.setAddedSize(0);
                    uploadBean.setProgress(0);
                    FDBManager.getInstance().addOrUpdateUploadBean(uploadBean);
                    if (callback != null) {
                        callback.onWaiting(uploadBean);
                    }else{
                        FSEventDispatcher.getInstance().onUploadWaiting(uploadBeanByLocalPath);
                    }

                }


                toUpload();

            }
        });
    }
    /**
     * 判断下载队列 并开启上传任务
     */
    public void toUpload() {

        if (isStopAll) {
            FLog.d(TAG, "已经暂停所有任务，不再请求上传");
            return;
        }

        FLog.d(TAG, "toUpload");
        long uploadTaskSize = getUploadTaskSize();
        FLog.d(TAG, "当前上传队列个数  " + uploadTaskSize + " maxThread = " + UploadParam.maxThread);
        //从数据库存中取出一个等待上传的上传任务 并开始上传
        if (uploadTaskSize < UploadParam.maxThread) {
            final UploadBean uploadBeanByStatus = FDBManager.getInstance().getUploadBeanByStatus(3);
            if (uploadBeanByStatus == null) {
                FLog.d(TAG, "没有需要上传的任务了");
            } else {

                FSUploadCallback callback = callbacks.get(uploadBeanByStatus.getLocalPath());

                BaseUploader uploader = null;
                if ("tcp".equals(uploadBeanByStatus.getProtocol())) {
                    uploader = new StartaiUploader(uploadBeanByStatus, callback);
                } else if ("http".equals(uploadBeanByStatus.getProtocol())) {
//                    uploader = new StartaiHttpUploader(uploadBeanByStatus, callback);


                    return;
                }
                if (callback != null) {
                    uploadBeanByStatus.setStatus(1);
                    FDBManager.getInstance().addOrUpdateUploadBean(uploadBeanByStatus);
                    callback.onStart(uploadBeanByStatus);
                }else{
                    FSEventDispatcher.getInstance().onUploadStart(uploadBeanByStatus);
                }
                //开始上传任务
                executorService.execute(uploader);
                maps.put(uploadBeanByStatus.getLocalPath(), uploader);
            }
        } else {
            FLog.d(TAG, "上传队列已经超过最大限制，等待上传中。。。");
        }

    }

}