package cn.com.startai.fssdk;

import cn.com.startai.fssdk.db.entity.DownloadBean;
import cn.com.startai.fssdk.db.entity.UploadBean;

/**
 * Created by Robin on 2017/9/14.
 * 419109715@qq.com 彬影
 */

public abstract class BaseUploader implements Runnable {


    public abstract int getUploadStatus();

    public abstract UploadBean getUploadBean();

    public abstract void stopUpload();

    public abstract void retry(int times);

    public abstract void onProgress(UploadBean uploadBean);

    public abstract void onWaiting(UploadBean uploadBean);

    public abstract void onStart(UploadBean uploadBean);

    public abstract void onSuccess(UploadBean uploadBean);

    public abstract void onFailue(UploadBean uploadBean, int errorCode);

    public abstract void onPause(UploadBean uploadBean);

    public static final int ERROR_CODE_NETWORK_UNVALIBLE = -2005;// 网络异常
    public static final int ERROR_CODE_CONN_SERVER_FAILED = -2007;// 连接服务器失败
    public static final int ERROR_CODE_LOCAL_PATH_NOT_EXIT = -2008;// 本地文件找不到
    public static final int ERROR_CODE_GET_FILE_INFO_FAILED = -2011;// 获取云端文件信息失败
    public static final int ERROR_CODE_UPLOAD_FAILED = -2015;// 上传出错
    public static final int ERROR_CODE_UPLOAD_TYPE = -2018;//  上传失败，不支持的上传类型


    public static final int ERROR_CODE_FILE_IS_UPLOADING = -2009;// 文件已经开始上传
    public static final int ERROR_CODE_UNABLE_TO_UPLOAD = -2014;// 无法进行tcp上传

}
