package cn.com.startai.fssdk;

import cn.com.startai.fssdk.db.entity.DownloadBean;

/**
 * Created by Robin on 2017/9/14.
 * 419109715@qq.com 彬影
 */

public abstract class BaseDownloader implements Runnable {

    public abstract DownloadBean getDownloadBean();

    public abstract int getDownloadStatus();

    public abstract void stopDownload();


    public abstract void onProgress(DownloadBean downloadBean);

    public abstract void onWaiting(DownloadBean downloadBean);

    public abstract void onStart(DownloadBean downloadBean);

    public abstract void onSuccess(DownloadBean downloadBean);

    public abstract void onFailue(DownloadBean downloadBean, int errorCode);

    public abstract void onPause(DownloadBean downloadBean);

    public static final int ERROR_CODE_WRITE_FILE_FAILED = -1003;// 本地文件写入失败
    public static final int ERROR_CODE_UNKNOW_EXCEPTION = -1004;// 服务器无法进行tcp下载该文件
    public static final int ERROR_CODE_NETWORK_UNVALIBLE = -1005;// 网络异常
    public static final int ERROR_CODE_DOWNLOAD_EXCEPTION = -1006;// 其他异常
    public static final int ERROR_CODE_CONN_SERVER_FAILED = -1007;// 连接服务器失败
    public static final int ERROR_CODE_LOCAL_PATH_NOT_EXIT = -1008;// 本地文件找不到
    public static final int ERROR_CODE_URL_FORMAT_ERROR = -1010;// URL格式不正确
    public static final int ERROR_CODE_LOCAL_SAVE_FILE_EXCPETION = -1011;// 本地文件操作异常
    public static final int ERROR_CODE_GET_FILEINFO_ERROR = -1012;// 获取文件服务器文件信息失败
    public static final int ERROR_CODE_UNKNOW_DOWNLOAD_TYPE = -1013;// 不支持的下载方式
    public static final int ERROR_CODE_FILE_TO_LARGE = -1021; // 文件下载异常 ，文件下载比实际的要大
    public static final int ERROR_CODE_FILE_CREATE_FAILED = -1024; // 本地文件创建失败

    public static final int ERROR_CODE_FILE_IS_DOWNLOADING = -1009;// 已经有正在下载的任务
    public static final int ERROR_CODE_FILE_NOT_COORECT = -1016;//文件与其hash值不匹配


    public static String getDownloadMsgByCode(int downloadErrorCode) {

        if (downloadErrorCode == ERROR_CODE_WRITE_FILE_FAILED) {
            return "本地文件写入失败";
        } else if (downloadErrorCode == ERROR_CODE_UNKNOW_EXCEPTION) {
            return "服务器无法进行tcp下载该文件";
        } else if (downloadErrorCode == ERROR_CODE_NETWORK_UNVALIBLE) {
            return "网络异常";
        } else if (downloadErrorCode == ERROR_CODE_DOWNLOAD_EXCEPTION) {
            return "其他异常";
        } else if (downloadErrorCode == ERROR_CODE_CONN_SERVER_FAILED) {
            return "连接服务器失败";
        } else if (downloadErrorCode == ERROR_CODE_LOCAL_PATH_NOT_EXIT) {
            return "本地文件找不到";
        } else if (downloadErrorCode == ERROR_CODE_LOCAL_SAVE_FILE_EXCPETION) {
            return "文件操作异常";
        } else if (downloadErrorCode == ERROR_CODE_FILE_IS_DOWNLOADING) {
            return "已经有正在下载的任务";
        } else if (downloadErrorCode == ERROR_CODE_URL_FORMAT_ERROR) {
            return "URL格式不正确";
        } else if (downloadErrorCode == ERROR_CODE_GET_FILEINFO_ERROR) {
            return "获取文件服务器文件信息失败";
        } else if (downloadErrorCode == ERROR_CODE_UNKNOW_DOWNLOAD_TYPE) {
            return "不支持的下载方式";
        } else if (downloadErrorCode == ERROR_CODE_FILE_NOT_COORECT) {
            return "文件与其hash值不匹配";
        } else if (downloadErrorCode == ERROR_CODE_FILE_CREATE_FAILED) {
            return "本地文件创建失败";
        } else if (downloadErrorCode == ERROR_CODE_FILE_TO_LARGE) {
            return "文件的下载比实际的要大";
        } else {
            return "";
        }

    }


}
