package cn.com.startai.common.utils;

import android.os.CountDownTimer;
import android.text.TextUtils;
import android.widget.Button;

public class CTimeCount extends CountDownTimer {

    private Button btn;
    private String textAfterClick; //倒计时中显示文件
    private String textAfterTimeOver;//倒计时结果显示文字
    private boolean clickAble; //倒计算时过程中按钮是否可点击
    private boolean timeLocationEnd; //时间是否显示在文字后方
    private ITimeCountListener listener;


    private CTimeCount(Builder builder) {
        super(builder.millisInFuture, builder.countdownInterval);
        btn = builder.btn;
        textAfterClick = builder.textAfterClick;
        textAfterTimeOver = builder.textAfterTimeOver;
        clickAble = builder.clickAble;
        timeLocationEnd = builder.timeLocationEnd;
        listener = builder.listener;
        if (TextUtils.isEmpty(textAfterClick)) {
            textAfterClick = btn.getText().toString();
        }
        if (TextUtils.isEmpty(textAfterTimeOver)) {
            textAfterTimeOver = btn.getText().toString();
        }
        TAndL.L("textAfterClick" + textAfterClick);
        TAndL.L("textAfterTimeOver" + textAfterTimeOver);
    }


    @Override
    public void onTick(final long millisUntilFinished) {
        btn.setClickable(clickAble);
        if (timeLocationEnd) {
            btn.setText(textAfterClick + "(" + millisUntilFinished / 1000 + "s)");
        } else {
            btn.setText("(" + millisUntilFinished / 1000 + "s)" + textAfterClick);
        }
    }

    @Override
    public void onFinish() {
        btn.setText(textAfterTimeOver);
        btn.setClickable(true);
        if (listener != null) {
            listener.onFinish();
        }
    }

    public interface ITimeCountListener {
        void onFinish();
    }

    public static final class Builder {
        private Button btn;
        private String textAfterClick;
        private String textAfterTimeOver;
        private boolean clickAble = true;
        private boolean timeLocationEnd;
        private long millisInFuture;
        private long countdownInterval;
        private ITimeCountListener listener;

        public Builder() {
        }

        public Builder listener(ITimeCountListener val) {
            this.listener = val;
            return this;
        }

        public Builder millisInFuture(long val) {
            millisInFuture = val;
            return this;
        }

        public Builder countdownInterval(long val) {
            countdownInterval = val;
            return this;
        }

        public Builder btn(Button val) {
            btn = val;
            return this;
        }


        public Builder textAfterClick(String val) {
            textAfterClick = val;
            return this;
        }

        public Builder textAfterTimeOver(String val) {
            textAfterTimeOver = val;
            return this;
        }

        public Builder clickAble(boolean val) {
            clickAble = val;
            return this;
        }

        public Builder timeLocationEnd(boolean val) {
            timeLocationEnd = val;
            return this;
        }

        public CTimeCount build() {
            return new CTimeCount(this);
        }

    }
}