package cn.com.startai.common.utils;


import android.support.annotation.NonNull;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

import static cn.com.startai.common.CommonSDKInterface.TAG;

/**
 * Created by Robin on 2019/5/14.
 * 419109715@qq.com 彬影
 */
public class CThreadPoolUtils {

    private int workThreaPoolCount = 3;

    private int netThreaPoolCount = 4;

    private ScheduledExecutorService workThreadPool;
    private ScheduledExecutorService netThreadPool;
    private ScheduledExecutorService singleConnectThreadPool;
    private ScheduledExecutorService singleLogThreadPool;

    private CThreadPoolUtils() {
    }

    public static CThreadPoolUtils getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final CThreadPoolUtils singleTonInstance = new CThreadPoolUtils();
    }

    public void init(int workThreaPoolCount, int netThreaPoolCount) {
        this.workThreaPoolCount = workThreaPoolCount;
        this.netThreaPoolCount = netThreaPoolCount;
    }

    public void release() {
        CLog.d(TAG, "CThreadPoolUtils.release()");
        shutDownNetThreadPool();
        shutDownWorkThreadPool();
        shutDownSingleConnectThreadPool();
        shutDownSingleLogThreadPool();
    }


    public ScheduledExecutorService getSingleLogThreadPool() {
        if (singleLogThreadPool == null) {
            singleLogThreadPool = Executors.newSingleThreadScheduledExecutor();
        }
        return singleLogThreadPool;
    }

    public ScheduledExecutorService getSingleConnectThreadPool() {
        if (singleConnectThreadPool == null) {
            singleConnectThreadPool = Executors.newSingleThreadScheduledExecutor();
        }
        return singleConnectThreadPool;
    }

    public ScheduledExecutorService getWorkThreadPool() {
        if (workThreadPool == null) {
            workThreadPool = Executors.newScheduledThreadPool(workThreaPoolCount);
        }
        return workThreadPool;
    }

    public ScheduledExecutorService getNetThreadPool() {
        if (netThreadPool == null) {
            netThreadPool = Executors.newScheduledThreadPool(netThreaPoolCount);
        }
        return netThreadPool;
    }


    public void shutDownNetThreadPool() {
        if (netThreadPool != null) {
            shutdownExecutorService(netThreadPool);
            netThreadPool = null;
            CLog.d(TAG, "netThreadPool = " + netThreadPool);
        }
    }

    public void shutDownWorkThreadPool() {
        if (workThreadPool != null) {
            shutdownExecutorService(workThreadPool);
            workThreadPool = null;
            CLog.d(TAG, "workThreadPool = " + workThreadPool);

        }
    }

    private void shutDownSingleConnectThreadPool() {
        if (singleConnectThreadPool != null) {
            shutdownExecutorService(singleConnectThreadPool);
            singleConnectThreadPool = null;
            CLog.d(TAG, "singleConnectThreadPool = " + singleConnectThreadPool);
        }
    }

    private void shutDownSingleLogThreadPool() {
        if (singleLogThreadPool != null) {
            shutdownExecutorService(singleLogThreadPool);
            singleLogThreadPool = null;
            CLog.d(TAG, "singleLogThreadPool = " + singleLogThreadPool);
        }
    }

    private void shutdownExecutorService(@NonNull ScheduledExecutorService executorService) {
        executorService.shutdown();
//        try {
//            if (!executorService.awaitTermination(1, TimeUnit.SECONDS)) {
//                executorService.shutdownNow();
//                if (!executorService.awaitTermination(1, TimeUnit.SECONDS)) {
//                    executorService.shutdownNow();
//                }
//            }
//        } catch (InterruptedException ie) {
//            executorService.shutdownNow();
//            Thread.currentThread().interrupt();
//        }
    }

    public void cancelScheduledFuture(ScheduledFuture schedule) {
        if (schedule != null && !schedule.isCancelled()) {
            schedule.cancel(true);
        }
    }
}
