package cn.com.startai.common.file;

import android.app.Application;
import android.os.Environment;

import java.io.File;

import cn.com.startai.common.utils.CFileUtils;
import cn.com.startai.common.utils.CLog;

import static cn.com.startai.common.CommonSDKInterface.TAG;

/**
 * Created by Robin on 2019/9/20.
 * 419109715@qq.com 彬影
 */
public abstract class AFileDirMaker {

    private static final String APP_PROJECT_PATH_NAME = "App";

    protected static final String APP_ROOT_PATH_NAME = "appRoot";

    protected AFileDirMaker() {
    }

    protected boolean exit = false;

    private Application mApplication;

    public void init(Application app) {

        if (exit) {
            return;
        }
        this.mApplication = app;
        exit = CFileUtils.createOrExistsDir(getAppRootPath())
                && CFileUtils.createOrExistsDir(getProjectPath())
                && CFileUtils.createOrExistsDir(getDBPath())
                && CFileUtils.createOrExistsDir(getCachePath())
                && CFileUtils.createOrExistsDir(getDebugPath())
                && CFileUtils.createOrExistsDir(geLogPath())
                && CFileUtils.createOrExistsDir(getFilePath())
                && CFileUtils.createOrExistsDir(getTempPath())
                && CFileUtils.createOrExistsDir(getMediaPath())
                && CFileUtils.createOrExistsDir(getDataPath())
                && CFileUtils.createOrExistsDir(getWebPath())
                && CFileUtils.createOrExistsDir(getResourcePath())
                && CFileUtils.createOrExistsDir(getDataPath())
                && CFileUtils.createOrExistsDir(getApkPath())
                && CFileUtils.createOrExistsDir(getImagePlayerPath())
                && CFileUtils.createOrExistsDir(getMusicPlayerPath())
                && CFileUtils.createOrExistsDir(getMediaPlayerPath())
                && CFileUtils.createOrExistsDir(getOtherPlayerPath());
        CLog.d(TAG, "AFileDirMaker exit = " + exit);
    }


    protected static final String APP_FILE_PATH_NAME = "file";

    /**
     * 本地资源
     */
    public File getFilePath() {
        return new File(getProjectPath(), APP_FILE_PATH_NAME);
    }

    protected static final String APP_RES_PATH_NAME = "res";

    /**
     * 本地资源
     */
    public File getResPath() {
        return new File(getProjectPath(), APP_RES_PATH_NAME);
    }

    protected static final String APP_DEBUG_PATH_NAME = "debug";

    /**
     * debug 目录
     */
    public File getDebugPath() {
        return new File(getProjectPath(), APP_DEBUG_PATH_NAME);
    }

    protected static final String APP_CACHE_PATH_NAME = "cache";

    /**
     * cache 目录
     */
    public File getCachePath() {
        return new File(getProjectPath(), APP_CACHE_PATH_NAME);
    }

    protected static final String APP_LOG_PATH_NAME = "log";

    /**
     * Log 目录
     */
    public File geLogPath() {
        return new File(getProjectPath(), APP_LOG_PATH_NAME);
    }

    protected static final String APP_DB_PATH_NAME = "db";

    /**
     * DB 目录
     */
    public File getDBPath() {
        return new File(getProjectPath(), APP_DB_PATH_NAME);
    }


    protected static final String APP_TEMP_PATH_NAME = "temp";

    /**
     * temp 目录
     */
    public File getTempPath() {
        return new File(getProjectPath(), APP_TEMP_PATH_NAME);
    }


    protected static final String APP_MEDIA_PATH_NAME = "media";

    /**
     * media 目录
     */
    public File getMediaPath() {
        return new File(getProjectPath(), APP_MEDIA_PATH_NAME);
    }


    /**
     * data 目录
     */
    public File getDataPath() {
        return new File(getProjectPath(), APP_DATA_PATH_NAME);
    }

    private static final String APP_DATA_PATH_NAME = "data";

    /**
     * apk 目录
     */
    public File getApkPath() {
        return new File(getProjectPath(), APP_APK_PATH_NAME);
    }

    private static final String APP_APK_PATH_NAME = "apk";

    /**
     * resource 目录
     */
    public File getResourcePath() {
        return new File(getProjectPath(), APP_RESOURCE_PATH_NAME);
    }

    private static final String APP_RESOURCE_PATH_NAME = "resource";

    /**
     * web 目录
     */
    public File getWebPath() {
        return new File(getProjectPath(), APP_WEB_PATH_NAME);
    }

    private static final String APP_WEB_PATH_NAME = "web";


    public File getImagePlayerPath() {
        return new File(getResourcePath(), APP_IMAGEPLAYER_PATH_NAME);
    }

    private static final String APP_IMAGEPLAYER_PATH_NAME = "imageplayer";

    public File getMediaPlayerPath() {
        return new File(getResourcePath(), APP_MEDIAPLAYER_PATH_NAME);
    }

    private static final String APP_MEDIAPLAYER_PATH_NAME = "mediaplayer";

    public File getMusicPlayerPath() {
        return new File(getResourcePath(), APP_MUSICPLAYER_PATH_NAME);
    }

    private static final String APP_MUSICPLAYER_PATH_NAME = "musicplayer";

    public File getOtherPlayerPath() {
        return new File(getResourcePath(), APP_OTHER_PATH_NAME);
    }

    private static final String APP_OTHER_PATH_NAME = "other";


    /**
     * 获取app缓存数据的目录
     */
    public File getProjectPath() {
        File file = initMyProjectPath();
        if (file != null) {
            return file;
        }
        return new File(getAppRootPath(), APP_PROJECT_PATH_NAME);
    }

    protected abstract File initMyProjectPath();


    /**
     * 获取公司域名缓存数据的目录
     */
    public File getAppRootPath() {

        String path = initMyAppRootPath();

        if (path == null) {
            path = APP_ROOT_PATH_NAME;
        }

        return new File(getStoragePath(), path);

    }


    protected String initMyAppRootPath() {
        return null;
    }


    /**
     * 获取系统存储目录
     */
    public File getStoragePath() {
        File directory = null;
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            directory = Environment.getExternalStorageDirectory().getAbsoluteFile();
        }
        if (directory == null || !directory.exists()) {
//            Environment.getExternalStorageDirectory().getPath()
            directory = new File(File.separator + "sdcard");
        }
        return directory;
    }


}
