package cn.com.startai.common.channel.udp.client;


import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

import cn.com.startai.common.channel.udp.IUDP;
import cn.com.startai.common.channel.udp.event.IUDPListener;
import cn.com.startai.common.channel.ICallListener;

/**
 * Created by Robin on 2019/3/20.
 * 419109715@qq.com 彬影
 */
public class UDPImpl implements IUDP {

    private IUDPListener udpListener;


    private UDPImpl() {
    }

    public static UDPImpl getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final UDPImpl singleTonInstance = new UDPImpl();
    }


    @Override
    public void init() {

    }

    @Override
    public void release() {
    }


    @Override
    public void send(String ip, int port, byte[] data, ICallListener listener) {
        DatagramPacket datagramPacket = getDatagramPacket(ip, port, data);
    }

    @Override
    public void sendDelay(String ip, int port, byte[] data, long delay, ICallListener listener) {
        DatagramPacket datagramPacket = getDatagramPacket(ip, port, data);
    }

    @Override
    public void broadcast(String ip, int port, byte[] data, ICallListener listener) {
        DatagramPacket datagramPacket = getDatagramPacket(ip, port, data);
    }

    @Override
    public void broadcastDelay(String ip, int port, byte[] data, long delay, ICallListener listener) {
        DatagramPacket datagramPacket = getDatagramPacket(ip, port, data);
    }

    @Override
    public DatagramPacket getDatagramPacket(String ip, int port, byte[] data) {

        InetAddress address = null;
        try {
            address = InetAddress.getByName(ip);
        } catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        return new DatagramPacket(data, data.length, address, port);
    }

    @Override
    public void setListener(IUDPListener listener) {
        this.udpListener = listener;
    }


}
