
package cn.com.startai.common.channel.mqtt.event;


import android.support.annotation.NonNull;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

import static cn.com.startai.common.CommonSDKInterface.TAG;


/**
 * Default ping sender implementation
 * <p>
 * <p>This class implements the {@link MqttPingSender} pinger interface
 * allowing applications to sendAsync ping packet to server every keep alive interval.
 * </p>
 *
 * @see MqttPingSender
 */
public class HeartPingSender implements MqttPingSender {

    private ClientComms comms;
    private IMqttHeartListener mqttHeartListener;
    private Timer timer;

    public HeartPingSender(@NonNull IMqttHeartListener mqttHeartListener) {
        this.mqttHeartListener = mqttHeartListener;
    }

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
    }

    @Override
    public void start() {
        timer = new Timer("MQTT Ping" );
        timer.schedule(new PingTask(), comms.getKeepAlive());
    }

    @Override
    public void stop() {
        if(timer != null){
            timer.cancel();
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        if (timer != null) {
            timer.schedule(new PingTask(), delayInMilliseconds);
        }
    }

    private class PingTask extends TimerTask {

        @Override
        public void run() {

            if (comms != null) {
                if (mqttHeartListener != null) {
                    mqttHeartListener.onHeartStart();
                }
                comms.checkForActivity(new IMqttActionListener() {
                    @Override
                    public void onSuccess(IMqttToken asyncActionToken) {
                        if (mqttHeartListener != null) {
                            mqttHeartListener.onHeartSuccess();
                        }
                    }

                    @Override
                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        if (mqttHeartListener != null) {
                            mqttHeartListener.onHeartFailed(exception);
                        }
                    }
                });
            }
        }
    }


}
