package cn.com.startai.common.utils.network;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.utils.CLog;

import static cn.com.startai.common.CommonSDKInterface.TAG;

/**
 * Created by Robin on 2019/3/26.
 * 419109715@qq.com 彬影
 */
public class CNetworkManager {

    private static final CNetworkManager networkManager = new CNetworkManager();

    private Application app;
    private NetworkInfo networkInfo;

    public NetworkInfo getNetworkInfo() {
        return networkInfo;
    }

    private CNetworkManager() {
    }

    public static CNetworkManager getInstance() {
        return networkManager;
    }

    public void init(Application application) {
        this.app = application;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        if (app != null && networkReceiver != null) {
            app.registerReceiver(networkReceiver, filter);
        }
    }

    public void release() {
        CLog.d(TAG, "CNetworkManager release");
        list.clear();
        if (networkReceiver != null && app != null) {
            app.unregisterReceiver(networkReceiver);
            app = null;
        }
    }

    private List<INetworkListener> list = new ArrayList<>();
    public static final String NETWORKTYPE_WIFI = "WIFI";
    public static final String NETWORKTYPE_MOBILE = "MOBILE";
    public static final String NETWORKTYPE_ENTHERNET = "ENTHERNET";
    public static final String NETWORKTYPE_UNKOWN = "UNKNOWN";

    private NetworkInfo.State state;
    private String networkType;

    public NetworkInfo.State getState() {
        return state;
    }

    public String getNetworkType() {
        return networkType;
    }

    private boolean isUnkownNetwork() {
        return NETWORKTYPE_UNKOWN.equals(networkType) || state == NetworkInfo.State.UNKNOWN;
    }

    public boolean isAvaliableNetwork(boolean outNetCheck) {
        if (isUnkownNetwork()) {
            return false;
        } else {
            if (outNetCheck) {
                //网已经连接 判断是否可上互联网
                return isRealConnectToIntnet();
            } else {
                return true;
            }
        }
    }

    public boolean isWifiConnected() {
        return networkType.equals(NETWORKTYPE_WIFI) && state == NetworkInfo.State.CONNECTED;
    }

    private boolean isRealConnectToIntnet() {

        boolean isAvailable;
        try {
            String host = "www.google.com";
            InetAddress byName = InetAddress.getByName("www.google.com");
            CLog.d(TAG, host + " byName = " + byName.getHostAddress());
            isAvailable = true;
        } catch (UnknownHostException e) {
            CLog.d(TAG, e.getMessage());
            isAvailable = false;
        }

        if (!isAvailable) {

            try {
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String host = "www.baidu.com";
                InetAddress byName = InetAddress.getByName(host);
                CLog.d(TAG, host + " byName = " + byName.getHostAddress());
                isAvailable = true;
            } catch (UnknownHostException e) {

                CLog.d(TAG, e.getMessage());
                isAvailable = false;
            }
        }

        return isAvailable;
    }


    public void addNetworkListener(INetworkListener listener) {
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void removeNetworkListener(INetworkListener listener) {
        if (list.contains(listener)) {
            list.remove(listener);
        }
    }

    void callbackNetworkStateChange(String networkType, NetworkInfo.State state) {
        for (INetworkListener listener : list) {
            listener.onNetworkStateChange(networkType, state);
        }
    }

    void callbackMobileConnected() {
        for (INetworkListener listener : list) {
            listener.onMobileConnected();
        }
    }

    void callbackWifiConnected() {
        for (INetworkListener listener : list) {
            listener.onWifiConnected();
        }
    }

    void callbackEthernetConnected() {
        for (INetworkListener listener : list) {
            listener.onEthernetConnected();
        }
    }

    void callbackUnkownNetworkState() {
        for (INetworkListener listener : list) {
            listener.onUnkownNetwork();
        }
    }

    private QXNetworkReceiver networkReceiver = new QXNetworkReceiver();

    class QXNetworkReceiver extends BroadcastReceiver {


        @Override
        public void onReceive(Context context, Intent intent) {

            ConnectivityManager manager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            String action = intent.getAction();


            NetworkInfo.State newState = NetworkInfo.State.UNKNOWN;
            String newNetworkType = NETWORKTYPE_UNKOWN;

            networkInfo = manager.getActiveNetworkInfo();

            if (networkInfo != null) { // connected to the internet
                newState = networkInfo.getState();
                newNetworkType = networkInfo.getTypeName();
            }

            CLog.e(TAG, "current networkType  " + newNetworkType + " state = " + newState);


            if (action != null && action.equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
                if (!newNetworkType.equals(networkType) || state != newState) {
                    networkType = newNetworkType;
                    state = newState;
                    callbackNetworkStateChange(newNetworkType, newState);
                }
            }

            if (newNetworkType.equals(NETWORKTYPE_UNKOWN) || newState.equals(NetworkInfo.State.UNKNOWN)) {
                callbackUnkownNetworkState();
                return;
            }

            if (newState == NetworkInfo.State.CONNECTED) {
                switch (newNetworkType) {
                    case NETWORKTYPE_WIFI:
                        callbackWifiConnected();
                        break;
                    case NETWORKTYPE_MOBILE:
                        callbackMobileConnected();
                        break;
                    case NETWORKTYPE_ENTHERNET:
                        callbackEthernetConnected();
                        break;
                    default:
                        break;
                }
            } else {
                callbackUnkownNetworkState();
            }
        }
    }
}
