package cn.com.startai.common.utils;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import cn.com.startai.common.utils.permission.CPermissionHelper;

/**
 * Created by Robin on 2019/3/21.
 * 419109715@qq.com 彬影
 */
public class CLog {

    public static boolean isDebug = true;
    private static String currDateStr;
    private static SimpleDateFormat yyyyMMddFormat;
    private static SimpleDateFormat defaultFormat;
    private static String versionName;
    private static SimpleDateFormat hHmmFormat;
    private static String logDir;
    private static String startaiDir;
    private static String AppDir;
    private static String sdcardPath;
    public static boolean isLogToFile = false;
    private static boolean isChangeFile;
    private static PrintStream psEx;
    private static PrintWriter pw;
    private static String lastFileName = "";

    public static void e(String tag, String msg) {
        if (isDebug) {
            Log.e(tag, msg);
        }
        if (isLogToFile) {
            file(tag, msg);
        }
    }


    public static void w(String tag, String msg) {
        if (isDebug) {
            Log.w(tag, msg);
        }
        if (isLogToFile) {
            file(tag, msg);
        }
    }

    public static void i(String tag, String msg) {
        if (isDebug) {
            Log.i(tag, msg);
        }
        if (isLogToFile) {
            file(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            Log.d(tag, msg);
        }
        if (isLogToFile) {
            file(tag, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (isDebug) {
            Log.v(tag, msg);
        }
        if (isLogToFile) {
            file(tag, msg);
        }
    }

    public static void file(String tag, String content) {
        file(new String[]{tag}, new String[]{content});
    }

    public static void file(final String[] tags, final String[] contents) {
        CPermissionHelper.requestStorage(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                CThreadPoolUtils.getInstance().getNetThreadPool().execute(new Runnable() {
                    @Override
                    public void run() {

                        saveLog(tags, contents);

                    }
                });

            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    public static void file(final Throwable  e) {
        CPermissionHelper.requestStorage(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                CThreadPoolUtils.getInstance().getNetThreadPool().execute(new Runnable() {
                    @Override
                    public void run() {
                        saveLog(e);
                    }
                });

            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }


    private static String initData() {
        if (defaultFormat == null) {
            defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss_SSS");
        }
        if (versionName == null) {
            versionName = CAppUtils.getAppInfo().getVersionName();
        }
        String title = "\nAppVersion:" + versionName
                + "\nTime:" + CTimeUtils.getNowString(defaultFormat)
                + "\n";
        return title;
    }

    private static String initExceptionData() {
        return initData() + "\nException:\n";
    }


    /**
     * 获取日志文件 当文件记录大小超过4M就创建一个新的文件
     *
     * @return
     */
    public static File getLogFile() {

        try {
            if (hHmmFormat == null) {
                hHmmFormat = new SimpleDateFormat("HHmmss");
            }
            String currTimeStr = CTimeUtils.getNowString(hHmmFormat);

            if (logDir == null) {
                sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath();
                startaiDir = sdcardPath + "/startai";
                AppDir = startaiDir + "/" + CAppUtils.getAppPackageName();
                logDir = AppDir + "/log";
            }
            File file = new File(logDir + "/log_" + currDateStr + ".txt");

            if (CFileUtils.createOrExistsDir(startaiDir)
                    && CFileUtils.createOrExistsDir(AppDir)
                    && CFileUtils.createOrExistsDir(logDir)
                    && CFileUtils.createOrExistsFile(file)) {


                String oldPath = file.getAbsolutePath();
                if (CFileUtils.getFileLength(file) > 4 * 1024 * 1024) {
//                if (CFileUtils.getFileLength(file) > 8 * 1024) {
                    isChangeFile = true;
                    String newFileName = CFileUtils.getFileNameNoExtension(oldPath) + currTimeStr + ".txt";
                    CFileUtils.delete(CFileUtils.getDirName(oldPath) + "/" + newFileName);
                    CFileUtils.rename(oldPath, newFileName);

                    File newFile = new File(logDir + "/log_" + currDateStr + ".txt");
                    CFileUtils.createOrExistsFile(newFile);
                    return newFile;
                } else {
                    isChangeFile = false;
                    return file;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;

    }


    private static String getTitle() {
        String sdk = Build.VERSION.RELEASE;// android版本号
        String model = Build.MODEL;// 设备型号
        String title = "\n" + "model:" + model + "\n" + "android Version:" + sdk + "\n" + "product:" + Build.PRODUCT + "\n";
        return title;

    }

    private synchronized static void saveLog(final String[] tags, final String[] contents) {

        if (tags == null || contents == null || tags.length == 0 || contents.length == 0 || contents.length != tags.length) {
            System.out.println("format error!");
            return;
        }


        long t = System.currentTimeMillis();
        if (yyyyMMddFormat == null) {
            yyyyMMddFormat = new SimpleDateFormat("yyyyMMdd");
        }
        currDateStr = CTimeUtils.getNowString(yyyyMMddFormat);
        String data = "";
        for (int i = 0; i < tags.length; i++) {
            if (TextUtils.isEmpty(contents[i])) {
                continue;
            }
            data = data + tags[i] + ":\n  " + contents[i] + "\n";
        }
        data = data + "\n";


        final String dataStr = initData();

        data = dataStr + data;
        try {
            File file = getLogFile();
            if (file == null) {
                return;
            }

            if (pw == null || isChangeFile || !lastFileName.equals(file.getName())) {
                pw = new PrintWriter(new FileOutputStream(file, true), true);
                lastFileName = file.getName();
            }
            if (CFileUtils.getFileLength(file) <= 0) {
                pw.write(getTitle());
            }
            pw.write(data);
            pw.flush();

        } catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getLocalizedMessage());

        }
        long t4 = System.currentTimeMillis();
        System.out.println("write log use time = " + (t4 - t));


    }


    /**
     * 保存日志
     *
     * @param ex
     */
    private synchronized static void saveLog(final Throwable ex) {

        if (yyyyMMddFormat == null) {
            yyyyMMddFormat = new SimpleDateFormat("yyyyMMdd");
        }
        currDateStr = CTimeUtils.date2String(new Date(), yyyyMMddFormat);
        try {

            File file = getLogFile();
            if (file == null) {
                return;
            }
            //创建一个临时文件
            if (psEx == null || isChangeFile) {
                psEx = new PrintStream(new FileOutputStream(file, true), true);
            }
            psEx.print(initExceptionData());
            ex.printStackTrace(psEx);

        } catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }

    }

    public static void releaseLogFileIO() {
        System.out.println("releaseLogFileIO");
        isChangeFile = false;
        if (psEx != null) {
            psEx.close();
            psEx = null;
        }
        if (pw != null) {
            pw.close();
            psEx = null;
        }
    }
}

