package cn.com.startai.common.channel.udp;

import java.net.DatagramPacket;

import cn.com.startai.common.channel.udp.event.IUDPListener;
import cn.com.startai.common.channel.ICallListener;

/**
 * Created by Robin on 2019/3/20.
 * 419109715@qq.com 彬影
 */
public interface IUDP {

    void send(String ip, int port, byte[] data, ICallListener listener);

    void sendDelay(String ip, int port, byte[] data, long delay, ICallListener listener);

    void broadcast(String ip, int port, byte[] data, ICallListener listener);

    void broadcastDelay(String ip, int port, byte[] data, long delay, ICallListener listener);

    DatagramPacket getDatagramPacket(String ip, int port, byte[] data);

    void setListener(IUDPListener listener);

    void init();

    void release();
}
