package cn.com.startai.common.channel.mqtt;

import android.content.Context;

import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

import java.security.KeyStore;

import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

import cn.com.startai.common.channel.mqtt.event.IMqttHeartListener;
import cn.com.startai.common.channel.mqtt.event.IMqttListener;


/**
 * Created by Robin on 2019/3/22.
 * 419109715@qq.com 彬影
 */
public class MqttParam {


    private String clientId;
    private String[] hosts;
    private boolean isCheckCrt;
    private String crtPath;
    private String crtPassword;
    private String mqusername;
    private String mqpassword;
    private boolean cleanSession;
    private int connectTimeOut;
    private int keepAliveInterval;
    private IMqttListener mqttListener;
    private IMqttHeartListener heartListener;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String[] getHosts() {
        return hosts;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public boolean isCheckCrt() {
        return isCheckCrt;
    }

    public void setCheckCrt(boolean checkCrt) {
        isCheckCrt = checkCrt;
    }

    public String getCrtPath() {
        return crtPath;
    }

    public void setCrtPath(String crtPath) {
        this.crtPath = crtPath;
    }

    public String getCrtPassword() {
        return crtPassword;
    }

    public void setCrtPassword(String crtPassword) {
        this.crtPassword = crtPassword;
    }

    public String getMqusername() {
        return mqusername;
    }

    public void setMqusername(String mqusername) {
        this.mqusername = mqusername;
    }

    public String getMqpassword() {
        return mqpassword;
    }

    public void setMqpassword(String mqpassword) {
        this.mqpassword = mqpassword;
    }

    public boolean isCleanSession() {
        return cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public int getConnectTimeOut() {
        return connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getKeepAliveInterval() {
        return keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public IMqttListener getMqttListener() {
        return mqttListener;
    }

    public void setMqttListener(IMqttListener mqttListener) {
        this.mqttListener = mqttListener;
    }

    public IMqttHeartListener getHeartListener() {
        return heartListener;
    }

    public void setHeartListener(IMqttHeartListener heartListener) {
        this.heartListener = heartListener;
    }

    private MqttParam(Builder builder) {
        clientId = builder.clientId;
        hosts = builder.hosts;
        isCheckCrt = builder.isCheckCrt;
        crtPath = builder.crtPath;
        crtPassword = builder.crtPassword;
        mqusername = builder.mqusername;
        mqpassword = builder.mqpassword;
        cleanSession = builder.cleanSession;
        connectTimeOut = builder.connectTimeOut;
        keepAliveInterval = builder.keepAliveInterval;
        mqttListener = builder.mqttListener;
        heartListener = builder.heartListener;
    }


    /**
     * 连接参数
     *
     * @return
     */
    public MqttConnectOptions getConnectOptions(Context context) {


        MqttConnectOptions options = new MqttConnectOptions();

        options.setCleanSession(cleanSession);
        options.setUserName(mqusername);
        options.setPassword(mqpassword.toCharArray());
        options.setKeepAliveInterval(keepAliveInterval);
        options.setConnectionTimeout(connectTimeOut);
        options.setMaxInflight(60);
        options.setServerURIs(hosts);
        options.setMqttVersion(MqttConnectOptions.MQTT_VERSION_3_1_1);


        if (isCheckCrt) {
            try {
                options.setSocketFactory(getSocketFactory(context, crtPath));
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        return options;
    }


    private SocketFactory getSocketFactory(Context ctx, String assestPath) throws Exception {
        SSLContext context;
        KeyStore ts = KeyStore.getInstance("BKS");
        ts.load(ctx.getResources().getAssets().open(assestPath),
                crtPassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory
                .getInstance("X509");
        tmf.init(ts);
        TrustManager[] tm = tmf.getTrustManagers();
        context = SSLContext.getInstance("SSL");
        context.init(null, tm, null);
        SocketFactory factory = context.getSocketFactory();
        return factory;
    }


    public static final class Builder {
        private String clientId;
        private String[] hosts;
        private boolean isCheckCrt;
        private String crtPath;
        private String crtPassword;
        private String mqusername;
        private String mqpassword;
        private boolean cleanSession;
        private int connectTimeOut;
        private int keepAliveInterval;
        private IMqttListener mqttListener;
        private IMqttHeartListener heartListener;

        public Builder() {
        }

        public Builder clientId(String val) {
            clientId = val;
            return this;
        }

        public Builder hosts(String[] val) {
            hosts = val;
            return this;
        }

        public Builder isCheckCrt(boolean val) {
            isCheckCrt = val;
            return this;
        }

        public Builder crtPath(String val) {
            crtPath = val;
            return this;
        }

        public Builder crtPassword(String val) {
            crtPassword = val;
            return this;
        }

        public Builder mqusername(String val) {
            mqusername = val;
            return this;
        }

        public Builder mqpassword(String val) {
            mqpassword = val;
            return this;
        }

        public Builder cleanSession(boolean val) {
            cleanSession = val;
            return this;
        }

        public Builder connectTimeOut(int val) {
            connectTimeOut = val;
            return this;
        }

        public Builder keepAliveInterval(int val) {
            keepAliveInterval = val;
            return this;
        }

        public Builder mqttListener(IMqttListener val) {
            mqttListener = val;
            return this;
        }

        public Builder heartListener(IMqttHeartListener val) {
            heartListener = val;
            return this;
        }

        public MqttParam build() {
            return new MqttParam(this);
        }
    }
}
