package cn.com.startai.common;

import android.app.Application;

import cn.com.startai.common.channel.ble.BleParam;
import cn.com.startai.common.channel.ble.IBle;
import cn.com.startai.common.channel.ble.client.BleImpl;
import cn.com.startai.common.channel.mqtt.IMqtt;
import cn.com.startai.common.channel.mqtt.MqttParam;
import cn.com.startai.common.channel.mqtt.client.MqttImpl;
import cn.com.startai.common.channel.udp.IUDP;
import cn.com.startai.common.channel.udp.UdpParam;
import cn.com.startai.common.channel.udp.client.UDPImpl;
import cn.com.startai.common.utils.CAppUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CThreadPoolUtils;
import cn.com.startai.common.utils.CUtils;
import cn.com.startai.common.utils.network.CNetworkManager;

/**
 * sdk 入口
 * 基于通信层的sdk 所有app都可以使用
 * Created by Robin on 2019/5/10.
 * 419109715@qq.com 彬影
 */
public class CommonSDKInterface {

    public static String TAG = "CSDK";

    private CommonSDKInterface() {
    }

    public static CommonSDKInterface getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final CommonSDKInterface singleTonInstance = new CommonSDKInterface();
    }


    private Application application;
    private IMqtt mqtt;
    private IUDP udp;
    private IBle ble;

    public Application getApplication() {
        if (application == null) {
            CLog.e(TAG, "please call init first");
        }
        return application;
    }

    private boolean isInit() {
        return application != null;
    }


    /**
     * Sdk initialization entry, can be called multiple times
     *
     * @param app
     */
    public void init(Application app) {

        if (app == null) {
            CLog.e(TAG, "app = null");
            return;
        }
        CLog.d(TAG, "CommonSDKInterface init");

        if (!isInit()) {
            application = app;
            CNetworkManager.getInstance().init(app);
            CUtils.get().init(app);

        }
    }

    public IMqtt getMqtt() {
        return mqtt;
    }

    public IUDP getUdp() {
        return udp;
    }

    public IBle getBle() {
        return ble;
    }


    public void release() {
        CLog.d(TAG, "CommonSDKInterface release");


        releaseMqtt();
        releaseBle();
        releaseUdp();

        CNetworkManager.getInstance().release();
        CThreadPoolUtils.getInstance().release();
        CUtils.get().release();
        application = null;
    }

    public IMqtt initMqtt(MqttParam param) {
        if (application != null) {
            mqtt = MqttImpl.getInstance();
            mqtt.init(application, param);
            return mqtt;
        } else {
            CLog.e(TAG, "please call 'CommonSdkInterface.init(app)' first");
            return null;
        }

    }

    public IUDP initUdp(UdpParam udpParam) {
        if (application != null) {
            udp = UDPImpl.getInstance();
            udp.init();
            return udp;
        } else {
            CLog.e(TAG, "please call 'CommonSdkInterface.init(app)' first");
            return null;
        }
    }

    public IBle initBle(BleParam bleParam) {
        if (application != null) {
            ble = BleImpl.getInstance();
            ble.init();
            return ble;
        } else {
            CLog.e(TAG, "please call 'CommonSdkInterface.init(app)' first");
            return null;
        }
    }

    public void releaseMqtt() {
        if (mqtt != null) {
            mqtt.release();
            mqtt = null;
        }

    }

    public void releaseUdp() {
        if (udp != null) {
            udp.release();
            udp = null;
        }
    }

    public void releaseBle() {
        if (ble != null) {
            ble.release();
            ble = null;
        }
    }

}
