package cn.com.startai.common.utils.permission;


import android.util.Log;

import java.util.List;

import static cn.com.startai.common.CommonSDKInterface.TAG;

/**
 * 权限请求
 */
public class CPermissionHelper {



    public static void requestStorage(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.STORAGE);
    }

    public static void requestPhone(OnPermissionGrantedListener onPermissionGrantedListener,
                                    OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.PHONE);
    }

    public static void requestSms(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.SMS);
    }

    public static void requestLocation(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.LOCATION);
    }

    public static void requestCamera(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.CAMERA);
    }

    public static void requestSensors(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.SENSORS);
    }

    public static void requestMicroPhone(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.MICROPHONE);
    }

    public static void requestContacts(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.CONTACTS);
    }

    public static void requestCalendar(OnPermissionGrantedListener onPermissionGrantedListener, OnPermissionDeniedListener onPermissionDeniedListener) {
        request(onPermissionGrantedListener, onPermissionDeniedListener, PermissionConstants.CALENDAR);
    }


    public static void request(final OnPermissionGrantedListener grantedListener,
                               final OnPermissionDeniedListener deniedListener,
                               final @PermissionConstants.Permission String... permissions) {
        PermissionUtils.permission(permissions)
                .rationale(new PermissionUtils.OnRationaleListener() {
                    @Override
                    public void rationale(ShouldRequest shouldRequest) {

                        DialogHelper.showRationaleDialog(shouldRequest);
                    }
                })
                .callback(new PermissionUtils.FullCallback() {
                    @Override
                    public void onGranted(List<String> permissionsGranted) {
                        if (grantedListener != null) {
                            grantedListener.onPermissionGranted();
                        }
                        Log.d(TAG, permissionsGranted.toString());
                    }

                    @Override
                    public void onDenied(List<String> permissionsDeniedForever, List<String> permissionsDenied) {
                        if (!permissionsDeniedForever.isEmpty()) {
                            DialogHelper.showOpenAppSettingDialog();
                        }
                        if (deniedListener != null) {
                            deniedListener.onPermissionDenied();
                        }
                        Log.d(TAG, permissionsDenied.toString());
                    }
                })
                .request();
    }

    public interface OnPermissionGrantedListener {
        void onPermissionGranted();
    }

    public interface OnPermissionDeniedListener {
        void onPermissionDenied();
    }
}
