package cn.com.startai.common.utils;

import android.os.CountDownTimer;
import android.widget.Button;

public class CTimeCount extends CountDownTimer {

    private Button btn;
    private String textPreClick;
    private String textAfterClick;
    private String textAfterTimeOver;

    public CTimeCount(long millisInFuture, long countDownInterval, Button btn) {
        super(millisInFuture, countDownInterval);
        this.btn = btn;
    }

    public CTimeCount(long millisInFuture, long countDownInterval) {
        super(millisInFuture, countDownInterval);
    }

    public CTimeCount(Builder builder) {
        super(builder.millisInFuture, builder.countDownInterval);
        btn = builder.btn;
        textPreClick = builder.textPreClick;
        textAfterClick = builder.textAfterClick;
        textAfterTimeOver = builder.textAfterTimeOver;
    }


    @Override
    public void onTick(final long millisUntilFinished) {
        btn.setClickable(false);
        btn.setText("(" + millisUntilFinished / 1000 + "s)" + textAfterClick);
    }

    @Override
    public void onFinish() {
        btn.setText(textAfterTimeOver);
        btn.setClickable(true);
    }

    public static final class Builder {
        private Button btn;
        private long millisInFuture;
        private long countDownInterval;
        private String textPreClick;
        private String textAfterClick;
        private String textAfterTimeOver;

        public Builder() {
        }

        public Builder btn(Button val) {
            btn = val;
            return this;
        }

        public Builder millisInFuture(long val) {
            millisInFuture = val;
            return this;
        }

        public Builder countDownInterval(long val) {
            countDownInterval = val;
            return this;
        }

        public Builder textPreClick(String val) {
            textPreClick = val;
            return this;
        }

        public Builder textAfterClick(String val) {
            textAfterClick = val;
            return this;
        }

        public Builder textAfterTimeOver(String val) {
            textAfterTimeOver = val;
            return this;
        }

        public CTimeCount build() {
            return new CTimeCount(this);
        }
    }
}