package cn.com.startai.common.utils;


import android.support.annotation.NonNull;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

/**
 * 项目 全局使用的线程池，有两个 一个是网络线池 核心线程数为3个，一个工作线程池 核心线程数为4个
 * 需要的时候才会初始化线程池，否则不会创建线程
 * Created by Robin on 2019/5/14.
 * 419109715@qq.com 彬影
 */
public class CThreadPoolUtils {

    private int workThreaPoolCount = 4;

    private int netThreaPoolCount = 3;

    private ScheduledExecutorService workThreadPool;
    private ScheduledExecutorService netThreadPool;

    private CThreadPoolUtils() {
    }

    public static CThreadPoolUtils getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final CThreadPoolUtils singleTonInstance = new CThreadPoolUtils();
    }

    public void init(int workThreaPoolCount, int netThreaPoolCount) {
        this.workThreaPoolCount = workThreaPoolCount;
        this.netThreaPoolCount = netThreaPoolCount;
    }

    public void release() {
        shutDownNetThreadPool();
        shutDownWorkThreadPool();
    }


    public ScheduledExecutorService getWorkThreadPool() {
        if (workThreadPool == null) {
            workThreadPool = Executors.newScheduledThreadPool(workThreaPoolCount);
        }
        return workThreadPool;
    }

    public ScheduledExecutorService getNetThreadPool() {
        if (netThreadPool == null) {
            netThreadPool = Executors.newScheduledThreadPool(netThreaPoolCount);
        }
        return netThreadPool;
    }

    public void shutDownNetThreadPool() {
        if (netThreadPool != null) {
            shutdownExecutorService(netThreadPool);
            netThreadPool = null;
        }
    }

    public void shutDownWorkThreadPool() {
        if (workThreadPool != null) {
            shutdownExecutorService(workThreadPool);
            workThreadPool = null;
        }
    }

    private void shutdownExecutorService(@NonNull ScheduledExecutorService executorService) {
        executorService.shutdown();
//        try {
//            if (!executorService.awaitTermination(1, TimeUnit.SECONDS)) {
//                executorService.shutdownNow();
//                if (!executorService.awaitTermination(1, TimeUnit.SECONDS)) {
//                    executorService.shutdownNow();
//                }
//            }
//        } catch (InterruptedException ie) {
//            executorService.shutdownNow();
//            Thread.currentThread().interrupt();
//        }
    }

    public void cancelScheduledFuture(ScheduledFuture schedule) {
        if (schedule != null && !schedule.isCancelled()) {
            schedule.cancel(true);
        }
    }
}
