package cn.com.startai.common.utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import cn.com.startai.common.utils.permission.CPermissionHelper;

import static cn.com.startai.common.CommonSDKInterface.TAG;

/**
 * Created by Robin on 2019/3/21.
 * 419109715@qq.com 彬影
 */
public class CLog {
    public static boolean isDebug = true;
    private static String currDateStr;


    public static void e(String tag, String msg) {
        if (isDebug) {
            Log.e(tag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (isDebug) {
            Log.w(tag, msg);
        }
    }

    public static void i(String tag, String msg) {
        if (isDebug) {
            Log.i(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            Log.d(tag, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (isDebug) {
            Log.v(tag, msg);
        }
    }

    public static void file(String tag, String content) {
        file(new String[]{tag}, new String[]{content});
    }

    public static void file(final String[] tags, final String[] contents) {
        CPermissionHelper.requestStorage(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                CThreadPoolUtils.getInstance().getNetThreadPool().execute(new Runnable() {
                    @Override
                    public void run() {
                        saveLog(CUtils.get().getApp(), tags, contents);
                    }
                });

            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    public static void file(final Exception e) {
        CPermissionHelper.requestStorage(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                CThreadPoolUtils.getInstance().getNetThreadPool().execute(new Runnable() {
                    @Override
                    public void run() {
                        saveLog(CUtils.get().getApp(), e);
                    }
                });

            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }


    private static String initData(Context context) {
        String title = "\nAppVersion:" + CAppUtils.getAppInfo().getVersionName()
                + "\nTime:" + CTimeUtils.date2String(new Date(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss_SSS"))
                + "\n";
        return title;
    }

    private static String initExceptionData(Context context) {
        return initData(context) + "\nException:\n";
    }


    /**
     * 获取日志文件 当文件记录大小超过4M就创建一个新的文件
     *
     * @return
     */
    public static File getLogFile() {

        try {

            String currTimeStr = CTimeUtils.date2String(new Date(), new SimpleDateFormat("HHmm"));

            String sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            File file = new File(sdcardPath + "/startai/log/log_"
                    + currDateStr + ".txt");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            String oldPath = file.getAbsolutePath();
            if (CFileUtils.getFileLength(file) > 4 * 1024 * 1024) {

                String newPath = oldPath.substring(0, oldPath.lastIndexOf(".txt")) + currTimeStr + ".txt";
                CFileUtils.rename(file.getAbsolutePath(), newPath);

                File newFile = new File(sdcardPath + "/startai/log/log_"
                        + currDateStr + ".txt");
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                if (!newFile.exists()) {
                    newFile.createNewFile();
                }
                return newFile;
            } else {
                return file;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;

    }


    private static String getTitle() {
        String sdk = Build.VERSION.RELEASE;// android版本号
        String model = Build.MODEL;// 设备型号
        return "\n" + "model:" + model + "\n" + "android Version:" + sdk + "\n" + "product:" + Build.PRODUCT + "\n";

    }

    private static void saveLog(final Context context, final String[] tags, final String[] contents) {

        if (tags == null || contents == null || tags.length == 0 || contents.length == 0 || contents.length != tags.length) {
            e(TAG, "format error!");
            return;
        }


        long t = System.currentTimeMillis();
        currDateStr = CTimeUtils.date2String(new Date(), new SimpleDateFormat("yyyyMMdd"));
        String data = "";
        for (int i = 0; i < tags.length; i++) {
            if (TextUtils.isEmpty(contents[i])) {
                continue;
            }
            data = data + tags[i] + ":\n  " + contents[i] + "\n";
        }
        data = data + "\n";


        final String dataStr = initData(context);
        data = dataStr + data;
        PrintWriter pwTemp = null;
        try {
            long t2 = System.currentTimeMillis();
            Log.i(TAG, "pre getlog time = " + (t2 - t));
            File file = getLogFile();
            long t3 = System.currentTimeMillis();
            Log.i(TAG, "get log file use time = " + (t3 - t2));
            if (file == null) {
                return;
            }

            OutputStream out = new FileOutputStream(file, true);
            pwTemp = new PrintWriter(out, true);
            if (CFileUtils.getFileLength(file) <= 0) {
                pwTemp.write(getTitle());
            }
            pwTemp.write(data);
            pwTemp.flush();

        } catch (IOException e) {
            e.printStackTrace();
            e("MyLog", e.getMessage());
        } finally {
            if (pwTemp != null) {
                pwTemp.close();
            }
        }
        long t2 = System.currentTimeMillis();
        Log.i(TAG, "write log use time = " + (t2 - t));


    }


    /**
     * 保存日志
     *
     * @param ex
     */
    private static void saveLog(final Context context, final Exception ex) {

        long time = System.currentTimeMillis();
        currDateStr = CTimeUtils.date2String(new Date(), new SimpleDateFormat("yyyyMMdd"));
        PrintStream psTemp = null;
        try {

            File file = getLogFile();
            if (file == null) {
                return;
            }
            //创建一个临时文件
            OutputStream out = new FileOutputStream(file, true);

            psTemp = new PrintStream(out, true);
            psTemp.print(initExceptionData(context));
            ex.printStackTrace(psTemp);

        } catch (IOException e) {
            e.printStackTrace();
            e(TAG, e.getMessage());
        } finally {
            if (psTemp != null) {
                psTemp.close();
            }
        }

    }

}

