
package cn.com.startai.common.channel.mqtt.event;


import android.support.annotation.NonNull;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;


/**
 * Default ping sender implementation
 * <p>
 * <p>This class implements the {@link MqttPingSender} pinger interface
 * allowing applications to sendAsync ping packet to server every keep alive interval.
 * </p>
 *
 * @see MqttPingSender
 */
public class HeartPingSender implements MqttPingSender {

    private IMqttHeartListener mqttHeartListener;
    private Timer timer;

    ScheduledExecutorService netThreadPool;
    private ScheduledFuture<?> schedulePing;

    public HeartPingSender(@NonNull ScheduledExecutorService netThreadPool, @NonNull IMqttHeartListener mqttHeartListener) {
        this.mqttHeartListener = mqttHeartListener;
        this.netThreadPool = netThreadPool;
    }

    private ClientComms comms;

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
    }


    @Override
    public void start() {

//        stop();
//        timer = new Timer(TAG + ":MqttPing");
//        timer.schedule(new PingTask(), comms.getKeepAlive());
        schedule(comms.getKeepAlive());
    }

    @Override
    public void stop() {
//        if (timer != null) {
//            timer.cancel();
//            timer = null;
//        }

        if (schedulePing != null) {
            schedulePing.cancel(true);
        }

    }

    @Override
    public void schedule(long delayInMilliseconds) {
//        if (timer != null) {
//            timer.schedule(new PingTask(), delayInMilliseconds);
//        }
        if (netThreadPool != null) {
            schedulePing = netThreadPool.schedule(new PingTask(), delayInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private class PingTask extends TimerTask {

        @Override
        public void run() {

            if (comms != null) {
                if (mqttHeartListener != null) {
                    mqttHeartListener.onHeartStart();
                }
                comms.checkForActivity(new IMqttActionListener() {
                    @Override
                    public void onSuccess(IMqttToken asyncActionToken) {
                        if (mqttHeartListener != null) {
                            mqttHeartListener.onHeartSuccess();
                        }
                    }

                    @Override
                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        if (mqttHeartListener != null) {
                            mqttHeartListener.onHeartFailed(exception);
                        }
                    }
                });
            }
        }
    }


}
