/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.riversoft.weixin.common.WxSslClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import com.riversoft.weixin.pay.PayWxClientFactory;
import com.riversoft.weixin.pay.base.BaseResponse;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.base.WxEndpoint;
import com.riversoft.weixin.pay.payment.bean.OrderQueryRequest;
import com.riversoft.weixin.pay.payment.bean.OrderQueryResponse;
import com.riversoft.weixin.pay.payment.bean.PaymentNotification;
import com.riversoft.weixin.pay.payment.bean.RefundQuery;
import com.riversoft.weixin.pay.payment.bean.RefundRequest;
import com.riversoft.weixin.pay.payment.bean.RefundResponse;
import com.riversoft.weixin.pay.payment.bean.UnifiedOrderRequest;
import com.riversoft.weixin.pay.payment.bean.UnifiedOrderResponse;
import com.riversoft.weixin.pay.util.SignatureUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Payments {
    private static Logger logger = LoggerFactory.getLogger(Payments.class);
    private PaySetting paySetting;
    private WxSslClient wxSslClient;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static Payments defaultOrders() {
        return Payments.with(PaySetting.defaultSetting());
    }

    public static Payments with(PaySetting paySetting) {
        Payments payments = new Payments();
        payments.setPaySetting(paySetting);
        payments.setWxSslClient(PayWxClientFactory.getInstance().with(paySetting));
        return payments;
    }

    public void setWxSslClient(WxSslClient wxSslClient) {
        this.wxSslClient = wxSslClient;
    }

    public UnifiedOrderResponse unifiedOrder(UnifiedOrderRequest unifiedOrderRequest) {
        UnifiedOrderRequestWrapper wrapper = new UnifiedOrderRequestWrapper();
        wrapper.setRequest(unifiedOrderRequest);
        this.setBaseSettings(wrapper);
        SortedMap unifiedOrderRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, unifiedOrderRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.unified");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 unified order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 unified order response: {}", (Object)response);
            UnifiedOrderResponseWrapper responseWrapper = (UnifiedOrderResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, UnifiedOrderResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "pre order failed:" + e.getMessage());
        }
    }

    public OrderQueryResponse query(OrderQueryRequest orderQueryRequest) {
        OrderQueryRequestWrapper wrapper = new OrderQueryRequestWrapper();
        wrapper.setRequest(orderQueryRequest);
        this.setBaseSettings(wrapper);
        SortedMap queryRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, queryRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.query");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 query order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 query order response: {}", (Object)response);
            OrderQueryResponseWrapper responseWrapper = (OrderQueryResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, OrderQueryResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "query order failed:" + e.getMessage());
        }
    }

    public BaseResponse close(String tradeNumber) {
        OrderCloseRequestWrapper wrapper = new OrderCloseRequestWrapper();
        wrapper.setTradeNumber(tradeNumber);
        this.setBaseSettings(wrapper);
        SortedMap closeOrderRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, closeOrderRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.close");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 close order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 close order response: {}", (Object)response);
            OrderCloseResponseWrapper responseWrapper = (OrderCloseResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, OrderCloseResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "close order failed:" + e.getMessage());
        }
    }

    public boolean checkSignature(PaymentNotification notification) {
        SortedMap notificationMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)notification, SortedMap.class);
        notificationMap.remove("sign");
        return notification.getSign().equals(SignatureUtil.sign(notificationMap, this.paySetting.getKey()));
    }

    public RefundResponse refund(RefundRequest refundRequest) {
        RefundRequestWrapper wrapper = new RefundRequestWrapper();
        wrapper.setRequest(refundRequest);
        this.setBaseSettings(wrapper);
        SortedMap refundRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, refundRequestMap);
        String url = WxEndpoint.get("url.pay.payment.refund.refund");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 refund request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 refund response: {}", (Object)response);
            RefundResponseWrapper responseWrapper = (RefundResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RefundResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "refund failed:" + e.getMessage());
        }
    }

    public RefundQuery refundQueryByTransactionId(String transactionId) {
        RefundQueryRequest refundQueryRequest = new RefundQueryRequest();
        refundQueryRequest.setTransactionId(transactionId);
        return this.refundQuery(refundQueryRequest);
    }

    public RefundQuery refundQueryByTradeNumber(String tradeNumber) {
        RefundQueryRequest refundQueryRequest = new RefundQueryRequest();
        refundQueryRequest.setTradeNumber(tradeNumber);
        return this.refundQuery(refundQueryRequest);
    }

    public RefundQuery refundQueryByRefundNumber(String refundNumber) {
        RefundQueryRequest refundQueryRequest = new RefundQueryRequest();
        refundQueryRequest.setRefundNumber(refundNumber);
        return this.refundQuery(refundQueryRequest);
    }

    public RefundQuery refundQueryByRefundId(String refundId) {
        RefundQueryRequest refundQueryRequest = new RefundQueryRequest();
        refundQueryRequest.setRefundId(refundId);
        return this.refundQuery(refundQueryRequest);
    }

    public RefundQuery refundQuery(RefundQueryRequest refundQueryRequest) {
        this.setBaseSettings(refundQueryRequest);
        SortedMap refundQueryRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)refundQueryRequest, SortedMap.class);
        this.sign(refundQueryRequest, refundQueryRequestMap);
        String url = WxEndpoint.get("url.pay.payment.refund.query");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)refundQueryRequest);
            logger.info("\u652f\u4ed8 refund query request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 refund query response: {}", (Object)response);
            RefundQueryWrapper refundQueryWrapper = (RefundQueryWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RefundQueryWrapper.class);
            return refundQueryWrapper.getRefundQuery();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "refund query failed:" + e.getMessage());
        }
    }

    public String downloadAllBill(Date date) {
        return this.downloadBill(date, "ALL");
    }

    public String downloadRefundBill(Date date) {
        return this.downloadBill(date, "REFUND");
    }

    public String downloadSuccessBill(Date date) {
        return this.downloadBill(date, "SUCCESS");
    }

    private String downloadBill(Date date, String type) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        BillRequest billRequest = new BillRequest();
        billRequest.setDate(dateFormat.format(date));
        billRequest.setType(type);
        this.setBaseSettings(billRequest);
        SortedMap billRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)billRequest, SortedMap.class);
        this.sign(billRequest, billRequestMap);
        String url = WxEndpoint.get("url.pay.payment.bill.download");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)billRequest);
            logger.info("\u652f\u4ed8 bill download request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 bill download response: {}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "bill download failed:" + e.getMessage());
        }
    }

    private void setBaseSettings(BaseSettings wrapper) {
        wrapper.setAppId(this.paySetting.getAppId());
        wrapper.setMchId(this.paySetting.getMchId());
    }

    private void sign(BaseSettings wrapper, SortedMap<String, Object> generals) {
        String nonce = RandomStringGenerator.getRandomStringByLength((int)32);
        generals.put("nonce_str", nonce);
        generals.put("mch_id", this.paySetting.getMchId());
        wrapper.setNonce(nonce);
        wrapper.setSign(SignatureUtil.sign(generals, this.paySetting.getKey()));
    }

    public static class BaseSettings {
        @JsonProperty(value="appid")
        private String appId;
        @JsonProperty(value="mch_id")
        private String mchId;
        @JsonProperty(value="nonce_str")
        private String nonce;
        private String sign;

        public String getMchId() {
            return this.mchId;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }
    }

    public static class BillRequest
    extends BaseSettings {
        @JsonProperty(value="bill_date")
        private String date;
        @JsonProperty(value="bill_type")
        private String type;

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class RefundQueryWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private RefundQuery refundQuery;

        public RefundQuery getRefundQuery() {
            return this.refundQuery;
        }

        public void setRefundQuery(RefundQuery refundQuery) {
            this.refundQuery = refundQuery;
        }
    }

    public static class RefundQueryRequest
    extends BaseSettings {
        @JsonProperty(value="transaction_id")
        private String transactionId;
        @JsonProperty(value="out_trade_no")
        private String tradeNumber;
        @JsonProperty(value="out_refund_no")
        private String refundNumber;
        @JsonProperty(value="refund_id")
        private String refundId;

        public String getTransactionId() {
            return this.transactionId;
        }

        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public String getTradeNumber() {
            return this.tradeNumber;
        }

        public void setTradeNumber(String tradeNumber) {
            this.tradeNumber = tradeNumber;
        }

        public String getRefundNumber() {
            return this.refundNumber;
        }

        public void setRefundNumber(String refundNumber) {
            this.refundNumber = refundNumber;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }
    }

    public static class RefundResponseWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private RefundResponse response;

        public RefundResponse getResponse() {
            return this.response;
        }

        public void setResponse(RefundResponse response) {
            this.response = response;
        }
    }

    public static class RefundRequestWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private RefundRequest request;

        public RefundRequest getRequest() {
            return this.request;
        }

        public void setRequest(RefundRequest request) {
            this.request = request;
        }
    }

    public static class OrderCloseResponseWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private BaseResponse response;

        public BaseResponse getResponse() {
            return this.response;
        }

        public void setResponse(BaseResponse response) {
            this.response = response;
        }
    }

    public static class OrderCloseRequestWrapper
    extends BaseSettings {
        @JsonProperty(value="out_trade_no")
        private String tradeNumber;

        public String getTradeNumber() {
            return this.tradeNumber;
        }

        public void setTradeNumber(String tradeNumber) {
            this.tradeNumber = tradeNumber;
        }
    }

    public static class OrderQueryResponseWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private OrderQueryResponse response;

        public OrderQueryResponse getResponse() {
            return this.response;
        }

        public void setResponse(OrderQueryResponse response) {
            this.response = response;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class OrderQueryRequestWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private OrderQueryRequest request;

        public void setRequest(OrderQueryRequest request) {
            this.request = request;
        }

        public OrderQueryRequest getRequest() {
            return this.request;
        }
    }

    public static class UnifiedOrderResponseWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private UnifiedOrderResponse response;

        public UnifiedOrderResponse getResponse() {
            return this.response;
        }

        public void setResponse(UnifiedOrderResponse response) {
            this.response = response;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class UnifiedOrderRequestWrapper
    extends BaseSettings {
        @JsonUnwrapped
        private UnifiedOrderRequest request;

        public void setRequest(UnifiedOrderRequest request) {
            this.request = request;
        }

        public UnifiedOrderRequest getRequest() {
            return this.request;
        }
    }
}

