/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.mp;

import com.riversoft.weixin.common.util.MD5;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.payment.bean.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsSigns {
    private static Logger logger = LoggerFactory.getLogger(JsSigns.class);
    private PaySetting paySetting;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static JsSigns defaultJsSigns() {
        return JsSigns.with(PaySetting.defaultSetting());
    }

    public static JsSigns with(PaySetting paySetting) {
        JsSigns jsSigns = new JsSigns();
        jsSigns.setPaySetting(paySetting);
        return jsSigns;
    }

    public Signature createSignature(String prepayId) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String pack = "prepay_id=" + prepayId;
        String sortString = String.format("appId=%s&nonceStr=%s&package=%s&signType=MD5&timeStamp=%s", this.paySetting.getAppId(), nonce, pack, timestamp);
        String signature = MD5.MD5Encode((String)(sortString + "&key=" + this.paySetting.getKey())).toUpperCase();
        Signature jsSignature = new Signature();
        jsSignature.setAppId(this.paySetting.getAppId());
        jsSignature.setNonce(nonce);
        jsSignature.setTimestamp(timestamp);
        jsSignature.setSignature(signature);
        jsSignature.setPack(pack);
        return jsSignature;
    }
}

