/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.app;

import com.riversoft.weixin.common.util.MD5;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.payment.bean.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSigns {
    private static Logger logger = LoggerFactory.getLogger(AppSigns.class);
    private PaySetting paySetting;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static AppSigns defaultAppSigns() {
        return AppSigns.with(PaySetting.defaultSetting());
    }

    public static AppSigns with(PaySetting paySetting) {
        AppSigns appSigns = new AppSigns();
        appSigns.setPaySetting(paySetting);
        return appSigns;
    }

    public Signature createSignature(String prepayId) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String pack = "Sign=WXPay";
        String sortString = String.format("appId=%s&nonceStr=%s&package=%s&partnerid=%s&&prepayid=%s&timeStamp=%s", this.paySetting.getAppId(), nonce, pack, this.paySetting.getMchId(), prepayId, timestamp);
        String signature = MD5.MD5Encode((String)(sortString + "&key=" + this.paySetting.getKey())).toUpperCase();
        Signature appSignature = new Signature();
        appSignature.setAppId(this.paySetting.getAppId());
        appSignature.setNonce(nonce);
        appSignature.setTimestamp(timestamp);
        appSignature.setSignature(signature);
        appSignature.setPack(pack);
        return appSignature;
    }
}

