/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.redpack;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.riversoft.weixin.common.WxSslClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import com.riversoft.weixin.pay.PayWxClientFactory;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.base.WxEndpoint;
import com.riversoft.weixin.pay.redpack.bean.RedPackRequest;
import com.riversoft.weixin.pay.redpack.bean.RedPackResponse;
import com.riversoft.weixin.pay.redpack.bean.RedPackResult;
import com.riversoft.weixin.pay.util.RandomStringGenerator;
import com.riversoft.weixin.pay.util.Signature;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedPacks {
    private static Logger logger = LoggerFactory.getLogger(RedPacks.class);
    private PaySetting paySetting;
    private WxSslClient wxSslClient;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static RedPacks defaultRedPacks() {
        return RedPacks.with(PaySetting.defaultSetting());
    }

    public static RedPacks with(PaySetting paySetting) {
        RedPacks redPacks = new RedPacks();
        redPacks.setPaySetting(paySetting);
        redPacks.setWxSslClient(PayWxClientFactory.getInstance().with(paySetting));
        return redPacks;
    }

    public void setWxSslClient(WxSslClient wxSslClient) {
        this.wxSslClient = wxSslClient;
    }

    public RedPackResponse sendSingle(RedPackRequest redPackRequest) {
        String url = WxEndpoint.get("url.pay.redpack.send.single");
        return this.send(url, redPackRequest);
    }

    public RedPackResponse sendGroup(RedPackRequest redPackRequest) {
        String url = WxEndpoint.get("url.pay.redpack.send.group");
        redPackRequest.setAmtType("ALL_RAND");
        return this.send(url, redPackRequest);
    }

    public RedPackResult query(String billNumber) {
        GetRedPackWrapper getRedPackWrapper = new GetRedPackWrapper();
        getRedPackWrapper.setBillNumber(billNumber);
        getRedPackWrapper.setBillType("MCHT");
        SortedMap redPackRequestMap = (SortedMap)JsonMapper.defaultMapper().getMapper().convertValue((Object)getRedPackWrapper, SortedMap.class);
        redPackRequestMap.put("appid", this.paySetting.getAppId());
        AppSettingMixin appSettingMixin = this.prepareAppSettingMixin(redPackRequestMap);
        getRedPackWrapper.setAppId(this.paySetting.getAppId());
        getRedPackWrapper.setAppSettingMixin(appSettingMixin);
        String url = WxEndpoint.get("url.pay.redpack.get");
        try {
            String xml = XmlObjectMapper.defaultMapper().toXml((Object)getRedPackWrapper);
            logger.info("send query redpack request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("got query response: {}", (Object)response);
            RedPackResultWrapper redPackResultWrapper = (RedPackResultWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RedPackResultWrapper.class);
            return redPackResultWrapper.getRedPackResult();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, " redpack failed:" + e.getMessage());
        }
    }

    private RedPackResponse send(String url, RedPackRequest redPackRequest) {
        if (redPackRequest.getAppId() == null || "".equals(redPackRequest.getAppId())) {
            redPackRequest.setAppId(this.paySetting.getAppId());
        }
        SortedMap redPackRequestMap = (SortedMap)JsonMapper.defaultMapper().getMapper().convertValue((Object)redPackRequest, SortedMap.class);
        AppSettingMixin appSettingMixin = this.prepareAppSettingMixin(redPackRequestMap);
        RedPackRequestWrapper redPackRequestWrapper = new RedPackRequestWrapper();
        redPackRequestWrapper.setAppSettingMixin(appSettingMixin);
        redPackRequestWrapper.setRedPackRequest(redPackRequest);
        try {
            String xml = XmlObjectMapper.defaultMapper().toXml((Object)redPackRequestWrapper);
            logger.info("send redpack request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("got response: {}", (Object)response);
            RedPackResponseWrapper redPackResponseWrapper = (RedPackResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RedPackResponseWrapper.class);
            return redPackResponseWrapper.getRedPackResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "send redpack failed:" + e.getMessage());
        }
    }

    private AppSettingMixin prepareAppSettingMixin(SortedMap<String, Object> generals) {
        AppSettingMixin appSettingMixin = new AppSettingMixin();
        String nonce = RandomStringGenerator.getRandomStringByLength(32);
        generals.put("nonce_str", nonce);
        generals.put("mch_id", this.paySetting.getMchId());
        appSettingMixin.setMchId(this.paySetting.getMchId());
        appSettingMixin.setNonce(nonce);
        appSettingMixin.setSign(Signature.sign(generals, this.paySetting.getKey()));
        return appSettingMixin;
    }

    public static class AppSettingMixin {
        @JsonProperty(value="mch_id")
        private String mchId;
        @JsonProperty(value="nonce_str")
        private String nonce;
        private String sign;

        public String getMchId() {
            return this.mchId;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }
    }

    public static class RedPackResultWrapper {
        @JsonUnwrapped
        private RedPackResult redPackResult;
        @JsonUnwrapped
        private AppSettingMixin appSettingMixin;

        public RedPackResult getRedPackResult() {
            return this.redPackResult;
        }

        public void setRedPackResult(RedPackResult redPackResult) {
            this.redPackResult = redPackResult;
        }

        public AppSettingMixin getAppSettingMixin() {
            return this.appSettingMixin;
        }

        public void setAppSettingMixin(AppSettingMixin appSettingMixin) {
            this.appSettingMixin = appSettingMixin;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class GetRedPackWrapper {
        @JsonProperty(value="mch_billno")
        private String billNumber;
        @JsonProperty(value="bill_type")
        private String billType;
        @JsonUnwrapped
        private AppSettingMixin appSettingMixin;
        @JsonProperty(value="appid")
        private String appId;

        public String getBillNumber() {
            return this.billNumber;
        }

        public void setBillNumber(String billNumber) {
            this.billNumber = billNumber;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public AppSettingMixin getAppSettingMixin() {
            return this.appSettingMixin;
        }

        public void setAppSettingMixin(AppSettingMixin appSettingMixin) {
            this.appSettingMixin = appSettingMixin;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class RedPackResponseWrapper {
        @JsonUnwrapped
        private RedPackResponse redPackResponse;
        @JsonProperty(value="wxappid")
        private String wxAppId;
        @JsonUnwrapped
        private AppSettingMixin appSettingMixin;

        public RedPackResponse getRedPackResponse() {
            return this.redPackResponse;
        }

        public void setRedPackResponse(RedPackResponse redPackResponse) {
            this.redPackResponse = redPackResponse;
        }

        public String getWxAppId() {
            return this.wxAppId;
        }

        public void setWxAppId(String wxAppId) {
            this.wxAppId = wxAppId;
        }

        public AppSettingMixin getAppSettingMixin() {
            return this.appSettingMixin;
        }

        public void setAppSettingMixin(AppSettingMixin appSettingMixin) {
            this.appSettingMixin = appSettingMixin;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    class RedPackRequestWrapper {
        @JsonUnwrapped
        private RedPackRequest redPackRequest;
        @JsonUnwrapped
        private AppSettingMixin appSettingMixin;

        RedPackRequestWrapper() {
        }

        public RedPackRequest getRedPackRequest() {
            return this.redPackRequest;
        }

        public void setRedPackRequest(RedPackRequest redPackRequest) {
            this.redPackRequest = redPackRequest;
        }

        public AppSettingMixin getAppSettingMixin() {
            return this.appSettingMixin;
        }

        public void setAppSettingMixin(AppSettingMixin appSettingMixin) {
            this.appSettingMixin = appSettingMixin;
        }
    }
}

