/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.base;

import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaySetting {
    private static Logger logger = LoggerFactory.getLogger(PaySetting.class);
    private static PaySetting paySetting = null;
    private String mchId;
    private String appId;
    private String key;
    private String certPath;
    private String certPassword;

    public static void setDefault(PaySetting paySetting) {
        PaySetting.paySetting = paySetting;
    }

    public static PaySetting defaultSetting() {
        if (paySetting == null) {
            PaySetting.loadFromSystemProperties();
        }
        if (paySetting == null) {
            PaySetting.loadFromClasspath();
        }
        if (paySetting == null) {
            throw new WxRuntimeException(999, "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u8bbe\u7f6e\u7f3a\u7701\u7684\u5546\u6237\u4fe1\u606f,\u8bf7\u4f7f\u7528setDefault\u65b9\u6cd5\u6216\u8005\u5728classpath\u4e0b\u9762\u521b\u5efawx-pay-settings.xml\u6587\u4ef6.");
        }
        return paySetting;
    }

    private static void loadFromSystemProperties() {
        if (System.getProperties().contains("payconfig")) {
            logger.info("loading pay configuration from system properties...");
            String xml = System.getProperties().getProperty("payconfig", "");
            logger.info("payconfig: {}", (Object)xml);
            if (xml == null || "".equals(xml)) {
                return;
            }
            try {
                PaySetting setting;
                paySetting = setting = (PaySetting)XmlObjectMapper.defaultMapper().fromXml(xml, PaySetting.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadFromClasspath() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-pay-settings-test.xml");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-pay-settings.xml");
            }
            if (inputStream != null) {
                PaySetting setting;
                String xml = IOUtils.toString((InputStream)inputStream);
                paySetting = setting = (PaySetting)XmlObjectMapper.defaultMapper().fromXml(xml, PaySetting.class);
            }
        }
        catch (IOException e) {
            logger.error("read settings from wx-pay-settings-test.xml or wx-pay-settings.xml failed:", (Throwable)e);
        }
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaySetting that = (PaySetting)o;
        if (!this.mchId.equals(that.mchId)) {
            return false;
        }
        return this.appId.equals(that.appId);
    }

    public int hashCode() {
        int result = this.mchId.hashCode();
        result = 31 * result + this.appId.hashCode();
        return result;
    }
}

