/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.open.base;

import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSetting {
    private static Logger logger = LoggerFactory.getLogger(AppSetting.class);
    private static AppSetting appSetting = null;
    private String appId;
    private String secret;

    public AppSetting() {
    }

    public AppSetting(String appId, String secret) {
        this.appId = appId;
        this.secret = secret;
    }

    public static void setDefault(AppSetting appSetting) {
        AppSetting.appSetting = appSetting;
    }

    public static AppSetting defaultSettings() {
        if (appSetting == null) {
            AppSetting.loadFromSystemProperties();
        }
        if (appSetting == null) {
            AppSetting.loadFromClasspath();
        }
        if (appSetting == null) {
            throw new WxRuntimeException(999, "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u8bbe\u7f6e\u7f3a\u7701\u7684appId\u548csecret,\u8bf7\u4f7f\u7528setDefault\u65b9\u6cd5\u6216\u8005\u5728classpath\u4e0b\u9762\u521b\u5efawx-open-settings.xml\u6587\u4ef6.");
        }
        return appSetting;
    }

    private static void loadFromSystemProperties() {
        if (System.getProperties().contains("openconfig")) {
            logger.info("loading open configuration from system properties...");
            String xml = System.getProperties().getProperty("openconfig", "");
            logger.info("openconfig: {}", (Object)xml);
            if (xml == null || "".equals(xml)) {
                return;
            }
            try {
                AppSetting setting;
                appSetting = setting = (AppSetting)XmlObjectMapper.defaultMapper().fromXml(xml, AppSetting.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadFromClasspath() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-open-settings-test.xml");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-open-settings.xml");
            }
            if (inputStream != null) {
                AppSetting setting;
                String xml = IOUtils.toString((InputStream)inputStream);
                appSetting = setting = (AppSetting)XmlObjectMapper.defaultMapper().fromXml(xml, AppSetting.class);
            }
        }
        catch (IOException e) {
            logger.error("read settings from wx-open-settings-test.xml or wx-open-settings.xml failed:", (Throwable)e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSetting that = (AppSetting)o;
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        return this.secret.equals(that.secret);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.secret.hashCode();
        return result;
    }
}

