/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common.decrypt;

import com.riversoft.weixin.common.decrypt.AesException;
import com.riversoft.weixin.common.decrypt.ByteGroup;
import com.riversoft.weixin.common.decrypt.PKCS7Encoder;
import com.riversoft.weixin.common.decrypt.SHA1;
import com.riversoft.weixin.common.decrypt.XMLParse;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecryption {
    static Charset CHARSET = Charset.forName("utf-8");
    private static Logger logger = LoggerFactory.getLogger(MessageDecryption.class);
    Base64 base64 = new Base64();
    byte[] aesKey;
    String token;
    String clientId;

    public MessageDecryption(String token, String aes, String clientId) throws AesException {
        if (aes.length() != 43) {
            logger.error("MessageDecryption constructs failed, aesKey size is not 43.");
            throw new AesException(-40004);
        }
        this.token = token;
        this.clientId = clientId;
        this.aesKey = Base64.decodeBase64((String)(aes + "="));
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    private String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private String encrypt(String randomStr, String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] corpidBytes = this.clientId.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(corpidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return this.base64.encodeToString(encrypted);
        }
        catch (Exception e) {
            logger.error("MessageDecryption encrypt failed.", (Throwable)e);
            throw new AesException(-40006);
        }
    }

    private String decrypt(String text) throws AesException {
        String from_corpid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            logger.error("MessageDecryption decrypt failed.", (Throwable)e);
            throw new AesException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_corpid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            logger.error("MessageDecryption decrypt failed.", (Throwable)e);
            throw new AesException(-40008);
        }
        if (!from_corpid.equals(this.clientId)) {
            logger.error("MessageDecryption decrypt failed, corpid mismatches.");
            throw new AesException(-40005);
        }
        return xmlContent;
    }

    public String encrypt(String replyMsg, String timeStamp, String nonce) throws AesException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if (timeStamp == "") {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        return XMLParse.generate(encrypt, signature, timeStamp, nonce);
    }

    public String decrypt(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        Object[] encrypt = XMLParse.extract(postData);
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt[1].toString());
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        return this.decrypt(encrypt[1].toString());
    }

    public String decryptEcho(String msgSignature, String timeStamp, String nonce, String echoStr) throws AesException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        return this.decrypt(echoStr);
    }
}

