/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common;

import com.riversoft.weixin.common.exception.WxRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxSslClient {
    private static Logger logger = LoggerFactory.getLogger(WxSslClient.class);
    protected CloseableHttpClient httpClient;
    RequestConfig requestConfig;

    public WxSslClient(String certPath, String certPassword) {
        KeyStore keyStore = null;
        SSLContext sslcontext = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream inputStream = new FileInputStream(new File(certPath));
            keyStore.load(inputStream, certPassword.toCharArray());
            sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, certPassword.toCharArray()).build();
        }
        catch (Exception e) {
            logger.error("initializing WxHttpsClient failed.", (Throwable)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(this.requestConfig);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            String responseContent;
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            String string = responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            return string;
        }
        catch (IOException ex) {
            logger.error("http get: {} failed.", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String post(String url, String content) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.requestConfig);
        httpPost.addHeader("Content-Type", "text/xml");
        if (content != null) {
            StringEntity entity = new StringEntity(content, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseContent;
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            String string = responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            return string;
        }
        catch (IOException ex) {
            logger.error("http post: {} failed", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }
}

