package cn.com.itep.printer.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbConstants;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.com.itep.printer.DeviceCode;
import cn.com.itep.printer.DeviceInfo;
import cn.com.itep.printer.PrinterListener;
import cn.com.itep.printer.PrinterStatusListener;
import cn.com.itep.printer.PrinterType;

/**
 * Created by 程辉 on 2016/9/8.
 */
public class UsbPrinterUtil {
    /**
     * 注册消息广播对象的过滤字符串
     */
    private static final String ACTION_USB_PERMISSION = "cn.com.itep.printer.USB_PERMISSION";

    private static final String TAG = "UsbPrinterUtil";

    private static UsbPrinterUtil mSelf = null;

    /**
     * 注册消息广播对象
     */
    private PendingIntent mPi;
    private UsbManager mUsbManager;                              /** 保存UsbManager对象 */
    private List<DeviceInfo> mlistUsbDev = new ArrayList<DeviceInfo>();/** 保存查询到的USB设备列表 */
    private Context mContext;
    private PrinterListener mPrinterListener;
    private PrinterStatusListener mPrinterStatusListener;
    private UsbDevListener mUsbDevListener;

    /**
     * 消息广播的接收器
     */
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();

            /** 如果当前接受的广播消息是指定的广播消息，那么执行if语句，得到Usb相关的操作对象 */
            if (ACTION_USB_PERMISSION.equals(action)) {
                synchronized (this) {
                    UsbDevice usbDevice = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
//                    UsbPrinter usbPrinter = UsbPrinter.getInstance(mContext);
                    //允许权限申请
                    if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                        Log.d("DEV", "得到访问权限\r\n");
//                        DeviceInfo deviceInfo = new DeviceInfo();
//                        deviceInfo.setDeviceName(usbDevice.getDeviceName());
//                        deviceInfo.setDeviceObject(usbDevice);
//                        usbPrinter.openDevice(deviceInfo);
                        openDevice(usbDevice);
                    } else {
                        Log.d("DEV", "申请权限被拒绝，无法发送树\r\n");
                    }
                }
            }
            else if (action.equals(UsbManager.ACTION_USB_DEVICE_ATTACHED)){
                Log.d("StartIPrint", "检测到USB接入");
                findDevice();
            }
            else if (action.equals(UsbManager.ACTION_USB_DEVICE_DETACHED)){
                Log.d("StartIPrint", "检测到USB拔出");
                findDevice();
            }
        }
    };

    public static UsbPrinterUtil getInstance(Context context){
        if (mSelf == null){
            mSelf = new UsbPrinterUtil(context);
        }

        return mSelf;
    }

    private UsbPrinterUtil(Context context){
        if (context.getApplicationContext() == null){
            mContext = context;
        }
        else{
            mContext = context.getApplicationContext();
        }

        mUsbManager = (UsbManager)mContext.getSystemService(Context.USB_SERVICE);

        //注册广播
        IntentFilter intentFilter = new IntentFilter(ACTION_USB_PERMISSION);
        intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        mContext.registerReceiver(mUsbReceiver, intentFilter);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();

        mContext.unregisterReceiver(mUsbReceiver);
    }

    public boolean findDevice(){
        mlistUsbDev.clear();

        final HashMap<String, UsbDevice> deviceHashMap = mUsbManager.getDeviceList();
        Log.d("Dev", "寻找到" + deviceHashMap.size() + "个设备\r\n");

        if (deviceHashMap.size() > 0){
            Iterator iter = deviceHashMap.entrySet().iterator();

            while (iter.hasNext()){
                Map.Entry<String, UsbDevice> entry = (Map.Entry<String, UsbDevice>)iter.next();
                DeviceInfo deviceInfo = new DeviceInfo();
                deviceInfo.setDeviceName(entry.getValue().getDeviceName());
                deviceInfo.setDeviceObject(entry.getValue());
                this.addDevice(deviceInfo);
            }
        }

//        if (mPrinterListener != null){
//            mPrinterListener.findPrinter(PrinterType.printToUsb, -2, null);
//        }

        return true;
    }

    /**
     * 增加设备
     * @param deviceInfo
     */
    public void addDevice(DeviceInfo deviceInfo){
        mlistUsbDev.add(deviceInfo);

        if (mPrinterListener != null){
            mPrinterListener.findPrinter(PrinterType.printToUsb, DeviceCode.AddDevice.getCode(), deviceInfo);
        }
    }

    public List<DeviceInfo> getDevices(){
        return mlistUsbDev;
    }

    public DeviceInfo getDevice(int position){
        if (position > mlistUsbDev.size() || position < 0){
            return null;
        }

        return mlistUsbDev.get(position);
    }

    /**
     * 设置监听器
     * @param printerListener
     */
    public void setPrinterListener(PrinterListener printerListener) {
        mPrinterListener = printerListener;
    }

    public PrinterListener getPrinterListener(){
        return mPrinterListener;
    }

    /**
     * 设备设备监听器
     * @param printerStatusListener
     */
    public void setPrinterStatusListener(PrinterStatusListener printerStatusListener) {
        mPrinterStatusListener = printerStatusListener;
    }

    /**
     * 设置usb设备专用监听器
     * @param usbDevListener
     */
    public void setUsbDevListener(UsbDevListener usbDevListener){
        mUsbDevListener = usbDevListener;
    }

    /**
     *  判断当前是否已经具备访问USB设备的权限
     * @param usbDevice 传入UsbDevice对象进行判断
     * @return 返回true表示当前具备权限，返回false表示不具备权限
     */
    public boolean hasPermission(UsbDevice usbDevice){
        return mUsbManager.hasPermission(usbDevice);
    }

    public void requestPermission(UsbDevice usbDevice, PendingIntent Pi){
        mUsbManager.requestPermission(usbDevice, Pi);
    }

    /**
     * 打开Usb设备
     * @param usbDevice
     */
    private void openDevice(UsbDevice usbDevice){
        UsbDev usbDev = new UsbDev();

        for (int i = 0, countInterface = usbDevice.getInterfaceCount(); i < countInterface; ++i){
            UsbInterface usbInterface = usbDevice.getInterface(i);
            do{
                if (usbInterface == null){
                    break;
                }

                for (int claimIndex = 0, pipeCount = usbInterface.getEndpointCount(); claimIndex < pipeCount; ++claimIndex){
                    UsbEndpoint usbEndpoint = usbInterface.getEndpoint(claimIndex);
                    if (usbEndpoint.getDirection() == UsbConstants.USB_DIR_IN){
                        usbDev.mUsbInputPoint = usbEndpoint;
                    }
                    else if (usbEndpoint.getDirection() == UsbConstants.USB_DIR_OUT){
                        usbDev.mUsbOutputpoint = usbEndpoint;
                    }
                }

//                if (this.mUsbOutputPoint == null/** || this.mUsbInputPoint == null **/){
//                    break;
//                }

                if (usbDev.mUsbOutputpoint == null){
                    break;
                }

                UsbDeviceConnection usbDeviceConnection = mUsbManager.openDevice(usbDevice);
                if (usbDeviceConnection == null){
                    break;
                }

                usbDev.mIsConnect = usbDeviceConnection.claimInterface(usbInterface, true);

                if (usbDev.mIsConnect){
                    usbDev.setUsbDevice(usbDevice);
                    usbDev.setUsbDeviceConnection(usbDeviceConnection);
                    usbDev.setUsbInterface(usbInterface);
                }

            }while (false);

            if (usbDev.mIsConnect){
                break;
            }
        }

        if (!usbDev.mIsConnect) {
            if (mPrinterListener != null) {
                mPrinterListener.openPrinter(PrinterType.printToUsb, DeviceCode.ErrorOpen.getCode());
            }
        }
        else {
            if (mPrinterListener != null) {
                mPrinterListener.openPrinter(PrinterType.printToUsb, DeviceCode.Opened.getCode());
            }

            if (mUsbDevListener != null){
                mUsbDevListener.openDevice(usbDev);
            }
        }
    }

    /**
     * 打开指定的设备
     * @param deviceInfo
     */
    public void openDevice(DeviceInfo deviceInfo){
        UsbDevice usbDevice = (UsbDevice)deviceInfo.getDeviceObject();

        // 判断是否具备权限，如果没有权限那么请求权限
        if (this.hasPermission(usbDevice)){
            openDevice(usbDevice);
        }
        else{
            mPi = PendingIntent.getBroadcast(mContext, 0, new Intent(ACTION_USB_PERMISSION), 0);
            this.requestPermission(usbDevice, mPi);
        }
    }
}
