package cn.com.itep.printer.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;

import java.util.List;

import cn.com.itep.printer.DeviceCode;
import cn.com.itep.printer.DeviceInfo;
import cn.com.itep.printer.Printer;
import cn.com.itep.printer.PrinterListener;
import cn.com.itep.printer.PrinterStatusListener;
import cn.com.itep.printer.PrinterType;

/**
 * Created by 辉 on 2015/6/25.
// * @Author 程辉
// * @Date 20150627
// * @Function UsbPrinter 封装与USB操作所有有关的类
 */
public class UsbPrinter extends Printer {

    /**
     * 注册消息广播对象的过滤字符串
     */
//    private static final String ACTION_USB_PERMISSION = "cn.com.itep.printer.USB_PERMISSION";
//
//    private final int mWriteTimeOut = 300000;
//
//    /**
//     * 注册消息广播对象
//     */
//    private PendingIntent mPi;
//
    private static UsbPrinter mSelf;                            /** 指向自身的类 */
    private UsbDev mUsbDev;
//    private UsbManager usbManager;                              /** 保存UsbManager对象 */
//    private List<DeviceInfo> mlistUsbDev = new ArrayList<DeviceInfo>();/** 保存查询到的USB设备列表 */
//    private boolean mIsOpen = false;                            /** 判断是否打开了USB设备 */
//    private UsbEndpoint mUsbOutputPoint;                        /** 保存USB输出节点 */
//    private UsbEndpoint mUsbInputPoint;                         /** 保存USB输入节点 */
//    private SelDeivceClass mSelDeivceClass;                     /** 所选择的USB设备信息保存 */
    private Context mContext;
//    private PrinterListener mPrinterListener;
//    private PrinterStatusListener mPrinterStatusListener;

    /**
     * 消息广播的接收器
     */
//    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {
//        public void onReceive(Context context, Intent intent) {
//            String action = intent.getAction();
//
//            /** 如果当前接受的广播消息是指定的广播消息，那么执行if语句，得到Usb相关的操作对象 */
//            if (ACTION_USB_PERMISSION.equals(action)) {
//                synchronized (this) {
//                    UsbDevice usbDevice = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
////                    UsbPrinter usbPrinter = UsbPrinter.getInstance(mContext);
//                    //允许权限申请
//                    if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
//                        Log.d("DEV", "得到访问权限\r\n");
////                        DeviceInfo deviceInfo = new DeviceInfo();
////                        deviceInfo.setDeviceName(usbDevice.getDeviceName());
////                        deviceInfo.setDeviceObject(usbDevice);
////                        usbPrinter.openDevice(deviceInfo);
//                        openDevice(usbDevice);
//                    } else {
//                        Log.d("DEV", "申请权限被拒绝，无法发送树\r\n");
//                    }
//                }
//            }
//        }
//    };

//    /**
//     *  构造函数
//     */
    protected UsbPrinter(Context context){
        mContext = context.getApplicationContext();
//        usbManager = (UsbManager)mContext.getSystemService(Context.USB_SERVICE);
//
//        //注册广播
//        IntentFilter usbfilter = new IntentFilter(ACTION_USB_PERMISSION);
//        mContext.registerReceiver(mUsbReceiver, usbfilter);
    }

    /**
     *  析构函数
     * @throws Throwable
     */
    @Override
    protected void finalize() throws Throwable {
        super.finalize();

//        mContext.unregisterReceiver(mUsbReceiver);
    }

    /**
     *  得到usb printer实例
     * @return 返回USBPrinter实例对象
     */
    public static UsbPrinter getInstance(Context context){

        if (mSelf == null){
            mSelf = new UsbPrinter(context);
        }

        return mSelf;
    }

    @Override
    public boolean initDevice() {
        return true;
    }

    /**
     *  查询所有链接的USB设备
     */
    @Override
    public boolean findDevice(){
//        mlistUsbDev.clear();
//
//        final HashMap<String, UsbDevice> deviceHashMap = usbManager.getDeviceList();
//        Log.d("Dev", "寻找到" + deviceHashMap.size() + "个设备\r\n");
//
//        if (deviceHashMap.size() > 0){
//            Iterator iter = deviceHashMap.entrySet().iterator();
//
//            while (iter.hasNext()){
//                Map.Entry<String, UsbDevice> entry = (Map.Entry<String, UsbDevice>)iter.next();
////                UsbDeivceInfo usbDeivceInfo = new UsbDeivceInfo();
////                usbDeivceInfo.setUsbName(entry.getKey());
////                usbDeivceInfo.setUsbDevice(entry.getValue());
//                DeviceInfo deviceInfo = new DeviceInfo();
//                deviceInfo.setDeviceName(entry.getValue().getDeviceName());
//                deviceInfo.setDeviceObject(entry.getValue());
//                mlistUsbDev.add(deviceInfo);
//            }
//        }

        UsbPrinterUtil.getInstance(mContext).findDevice();

        return true;
    }

    @Override
    public boolean stopfindDevice() {
        return true;
    }

    @Override
    public void addDevice(DeviceInfo deviceInfo) {
//        mlistUsbDev.add(deviceInfo);
        UsbPrinterUtil.getInstance(mContext).addDevice(deviceInfo);
    }

    /**
     *  得到设备列表缓存
     * @return
     */
    @Override
    public List<DeviceInfo> getDevices(){
//        return mlistUsbDev;
        return UsbPrinterUtil.getInstance(mContext).getDevices();
    }

    /**
     *  得到所选择的USB设备列表
     * @param position
     * @return
     */
    @Override
    public DeviceInfo getDevice(int position){
//        if (position > mlistUsbDev.size() || position < 0){
//            return null;
//        }
//
//        return mlistUsbDev.get(position);
        return UsbPrinterUtil.getInstance(mContext).getDevice(position);
    }

    @Override
    public void setPrinterListener(PrinterListener printerListener) {
//        mPrinterListener = printerListener;
        UsbPrinterUtil.getInstance(mContext).setPrinterListener(printerListener);
    }

    @Override
    public void setPrinterStatusListener(PrinterStatusListener printerStatusListener) {
//        mPrinterStatusListener = printerStatusListener;
        UsbPrinterUtil.getInstance(mContext).setPrinterStatusListener(printerStatusListener);
    }

    /**
     *  判断当前是否已经具备访问USB设备的权限
     * @param usbDevice 传入UsbDevice对象进行判断
     * @return 返回true表示当前具备权限，返回false表示不具备权限
     */
//    public boolean hasPermission(UsbDevice usbDevice){
//        return usbManager.hasPermission(usbDevice);
//    }
//
//    public void requestPermission(UsbDevice usbDevice, PendingIntent Pi){
//        usbManager.requestPermission(usbDevice, Pi);
//    }

//    private void openDevice(UsbDevice usbDevice){
//        for (int i = 0, countInterface = usbDevice.getInterfaceCount(); i < countInterface; ++i){
//            UsbInterface usbInterface = usbDevice.getInterface(i);
//            do{
//                if (usbInterface == null){
//                    break;
//                }
//
//                for (int claimIndex = 0, pipeCount = usbInterface.getEndpointCount(); claimIndex < pipeCount; ++claimIndex){
//                    UsbEndpoint usbEndpoint = usbInterface.getEndpoint(claimIndex);
//                    if (usbEndpoint.getDirection() == UsbConstants.USB_DIR_IN){
//                        mUsbInputPoint = usbEndpoint;
//                    }
//                    else if (usbEndpoint.getDirection() == UsbConstants.USB_DIR_OUT){
//                        mUsbOutputPoint = usbEndpoint;
//                    }
////                    else{
////                        mUsbOutputPoint = null;
////                        mUsbInputPoint = null;
////                    }
//                }
//
//                if (this.mUsbOutputPoint == null/** || this.mUsbInputPoint == null **/){
//                    break;
//                }
//
//                UsbDeviceConnection usbDeviceConnection = usbManager.openDevice(usbDevice);
//                if (usbDeviceConnection == null){
//                    break;
//                }
//
//                mIsOpen = usbDeviceConnection.claimInterface(usbInterface, true);
//
//                if (mIsOpen){
//                    mSelDeivceClass = new SelDeivceClass();
//                    mSelDeivceClass.setUsbDevice(usbDevice);
//                    mSelDeivceClass.setUsbDeviceConnection(usbDeviceConnection);
//                    mSelDeivceClass.setUsbInterface(usbInterface);
//                }
//
//            }while (false);
//
//            if (mIsOpen){
//                break;
//            }
//        }
//
//        //
////        UsbDeviceConnection usbDeviceConnection = usbManager.openDevice(usbDevice);
////        for (int i = 0, countInterface = usbDevice.getInterfaceCount(); i < countInterface; ++i) {
////            UsbInterface usbInterface = usbDevice.getInterface(i);
////            mIsOpen = usbDeviceConnection.claimInterface(usbInterface, true);
////
////            Log.d("DEV", "打开设备" + (mIsOpen ? "成功" : "失败") + "\r\n");
////
////            if (mIsOpen) {
////                mSelDeivceClass = new SelDeivceClass();
////                mSelDeivceClass.setUsbDevice(usbDevice);
////                mSelDeivceClass.setUsbDeviceConnection(usbDeviceConnection);
////                mSelDeivceClass.setUsbInterface(usbInterface);
////                mIsOpen = false;
////
////                for (int j = 0, count = usbInterface.getEndpointCount(); j < count; ++j) {
////                    if (usbInterface.getEndpoint(j).getDirection() == UsbConstants.USB_DIR_OUT) {
////                        mIsOpen = true;
////                        mUsbOutputPoint = usbInterface.getEndpoint(j);
////                    } else if (usbInterface.getEndpoint(j).getDirection() == UsbConstants.USB_DIR_IN) {
////                        mUsbInputPoint = usbInterface.getEndpoint(j);
////                    }
////                }
////
////                if (!mIsOpen) {
////                    usbDeviceConnection.releaseInterface(usbInterface);
////                } else {
////                    break;
////                }
////            }
////        }
//
//        if (!mIsOpen) {
//            if (mSelDeivceClass != null){
//                if (mSelDeivceClass.getUsbInterface() != null && mSelDeivceClass.getUsbDeviceConnection() != null){
//                    mSelDeivceClass.getUsbDeviceConnection().releaseInterface(mSelDeivceClass.getUsbInterface());
//                }
//                else if (mSelDeivceClass.getUsbDeviceConnection() != null) {
//                    mSelDeivceClass.getUsbDeviceConnection().close();
//                }
//                mSelDeivceClass = null;
//            }
////            mPrinterFind.findFinish(-211);
//            if (mPrinterListener != null) {
//                mPrinterListener.openPrinter(PrinterType.printToUsb, -1);
//            }
//        }
//        else {
////            mPrinterFind.findFinish(211);
//            if (mPrinterListener != null) {
//                mPrinterListener.openPrinter(PrinterType.printToUsb, 0);
//            }
//        }
//    }

    public void openDevice(int pid, int vid){
        UsbPrinterUtil.getInstance(mContext).findDevice();
        List<DeviceInfo> deviceList = UsbPrinterUtil.getInstance(mContext).getDevices();

        DeviceInfo findDevice = null;
        if (deviceList != null){
            for (DeviceInfo deviceInfo : deviceList){
                UsbDevice usbDevice = (UsbDevice)deviceInfo.getDeviceObject();

                if (usbDevice.getProductId() == pid && usbDevice.getVendorId() == vid){
                    findDevice = deviceInfo;
                    break;
                }
            }
        }

        if (findDevice != null){
            this.openDevice(findDevice);
        }
        else{
            if (UsbPrinterUtil.getInstance(mContext).getPrinterListener() != null) {
                UsbPrinterUtil.getInstance(mContext).getPrinterListener().openPrinter(PrinterType.printToUsb, DeviceCode.ErrorOpen.getCode());
            }
        }
    }

    /**
     *  得到访问USB设备的输出输入节点
     * @param deviceInfo 传入UsbDevice对象
//     * @return 返回true表示得到成功，返回false表示取得失败
     */
    @Override
    public void openDevice(DeviceInfo deviceInfo){
        UsbPrinterUtil.getInstance(mContext).setUsbDevListener(new UsbDevListener() {
            @Override
            public void openDevice(UsbDev usbDev) {
                mUsbDev = usbDev;
            }
        });

        UsbPrinterUtil.getInstance(mContext).openDevice(deviceInfo);
//        if (IsConnect()){
//            closeDevice();
//        }
//
//        UsbDevice usbDevice = (UsbDevice)deviceInfo.getDeviceObject();
//
//        if (this.hasPermission(usbDevice)) {
//            openDevice(usbDevice);
////            UsbDeviceConnection usbDeviceConnection = usbManager.openDevice(usbDevice);
////            for (int i = 0, countInterface = usbDevice.getInterfaceCount(); i < countInterface; ++i) {
////                UsbInterface usbInterface = usbDevice.getInterface(i);
////                mIsOpen = usbDeviceConnection.claimInterface(usbInterface, true);
////
////                Log.d("DEV", "打开设备" + (mIsOpen ? "成功" : "失败") + "\r\n");
////
////                if (mIsOpen) {
////                    mSelDeivceClass = new SelDeivceClass();
////                    mSelDeivceClass.setUsbDevice(usbDevice);
////                    mSelDeivceClass.setUsbDeviceConnection(usbDeviceConnection);
////                    mSelDeivceClass.setUsbInterface(usbInterface);
////                    mIsOpen = false;
////
////                    for (int j = 0, count = usbInterface.getEndpointCount(); j < count; ++j) {
////                        if (usbInterface.getEndpoint(j).getDirection() == UsbConstants.USB_DIR_OUT) {
////                            mIsOpen = true;
////                            mUsbOutputPoint = usbInterface.getEndpoint(j);
////                        } else if (usbInterface.getEndpoint(j).getDirection() == UsbConstants.USB_DIR_IN) {
////                            mUsbInputPoint = usbInterface.getEndpoint(j);
////                        }
////                    }
////
////                    if (!mIsOpen) {
////                        usbDeviceConnection.releaseInterface(usbInterface);
////                    } else {
////                        break;
////                    }
////                }
////            }
////
////            if (!mIsOpen) {
////                usbDeviceConnection.close();
////            }
//        }
//        else {
//            mPi = PendingIntent.getBroadcast(mContext, 0, new Intent(ACTION_USB_PERMISSION), 0);
//            this.requestPermission(usbDevice, mPi);
//        }
    }

//    protected void setPrinterCode(int printerCode){
//        if (mprinterFinder != null){
//            mprinterFinder.findFinish(printerCode);
//        }
//    }

    @Override
    public boolean IsConnect(){
//        return mIsOpen;

        if (mUsbDev != null) {
            return mUsbDev.IsConnect();
        }
        else{
            return false;
        }
    }

    public String getUsbPrintName(){
//        if(IsConnect()){
//            return mSelDeivceClass.getUsbDevice().getDeviceName();
//        }
//
//        return "";

        if (mUsbDev != null) {
            return mUsbDev.getUsbPrinterName();
        }
        else {
            return "";
        }
    }

    /**
     *  获取打印机的状态
     * @return 24表示打印机就绪，48表示打印机缺纸
     */
    @Override
    public byte getStatus() {

//        if (mIsOpen){
//            UsbDeviceConnection usbDeviceConnection = mSelDeivceClass.getUsbDeviceConnection();
//
//            byte[] buffer = new byte[64];
//            //参数参考libusb
//            usbDeviceConnection.controlTransfer(0xa1, 0x01, 0x00, 0x00, buffer, 64, 5000);
//            return buffer[0];
//        }
//
//        return -1;
        if (mUsbDev != null) {
            return mUsbDev.getStatus();
        }
        else{
            return -1;
        }
    }

//    public String getDeviceName(){
//        if (mIsOpen){
//            UsbDeviceConnection usbDeviceConnection = mSelDeivceClass.getUsbDeviceConnection();
//
//            byte[] buffer = new byte[128];
//
//            usbDeviceConnection.controlTransfer(0xa1, 0x01, 0x00, 0x00, buffer, 64, 5000);
//        }
//    }

    /**
     *  向指定的端口输出数据
     * @param outBuff 传入缓存
     * @param outLength 传入缓存数据的长度
     * @return 返回实际写入数据的长度，返回-1表示设备端口并未打开，写入失败
     */
    @Override
    public int writeDevice(byte[] outBuff, int outLength){

        if (mUsbDev != null) {
            return mUsbDev.writeDevice(outBuff, outLength);
        }
        else{
            return -1;
        }

//        this.getStatus();

//        int writeLength = -1;
//        if (mIsOpen) {
//            UsbDeviceConnection usbDeviceConnection = mSelDeivceClass.getUsbDeviceConnection();
//
////            if (outLength < PrinterTarget.PackageSize) {
////            int writeLength = usbDeviceConnection.bulkTransfer(mUsbOutputPoint, outBuff, outLength, 30000);
////            if (writeLength < 0){
////                mIsOpen = false;
////            }
////            return writeLength;
////            }
//            try {
//
//                if (outLength <= PrinterTarget.PackageSize) {
//                    writeLength = usbDeviceConnection.bulkTransfer(mUsbOutputPoint, outBuff, outLength, mWriteTimeOut);
//                    if (writeLength < 0){
//                        throw new Exception();
//                    }
//                }
//                else{
//                    int n = outLength / PrinterTarget.PackageSize;
//                    int m = outLength % PrinterTarget.PackageSize;
//
//                    byte[] buffer = new byte[PrinterTarget.PackageSize];
//
//                    for (int i = 0; i < n; ++i)
//                    {
//                        for (int j = 0; j < PrinterTarget.PackageSize; ++j){
//                            buffer[j] = outBuff[i * PrinterTarget.PackageSize + j];
//                        }
//                        writeLength = usbDeviceConnection.bulkTransfer(mUsbOutputPoint, buffer, PrinterTarget.PackageSize, mWriteTimeOut);
//
//                        if (writeLength < 0){
//                            throw new Exception();
//                        }
//                    }
//
//                    for (int j = 0; j < m; ++j){
//                        buffer[j] = outBuff[n * PrinterTarget.PackageSize + j];
//                    }
//                    writeLength = usbDeviceConnection.bulkTransfer(mUsbOutputPoint, buffer, m, mWriteTimeOut);
//                    if (writeLength < 0){
//                        throw new Exception();
//                    }
//                }
//            }catch (Exception e){
//                mIsOpen = false;
//                e.printStackTrace();
//
//                if (mPrinterStatusListener != null){
//                    mPrinterStatusListener.disconnect(PrinterType.printToUsb, 0);
//                }
//            }
//        }
//
//        return writeLength;
    }

    /**
     *  读取指定端口的数据
     * @return 返回实际读取数据的长度
     */
    @Override
    public byte[] readDevice(){

        if (mUsbDev != null) {
            return mUsbDev.readDevice();
        }
        else{
            return new byte[0];
        }

//        byte[] inBuff = null;
//        int length = -1;
//
//        if (mIsOpen){
//            List<Byte> listInBuff = new ArrayList<>();
//            inBuff = new byte[1024];
//
//            while (true) {
//                UsbDeviceConnection usbDeviceConnection = mSelDeivceClass.getUsbDeviceConnection();
//                length = usbDeviceConnection.bulkTransfer(mUsbInputPoint, inBuff, inBuff.length, 3000);
//
//                if (length <= 0){
//                    inBuff = null;
//                    break;
//                }
//
//                for (int i = 0; i < length; ++i){
//                    listInBuff.add(inBuff[i]);
//                }
//            }
//
//            inBuff = new byte[listInBuff.size()];
//            for (int i = 0; i < listInBuff.size(); ++i){
//                inBuff[i] = listInBuff.get(i);
//            }
//        }
//
//        if (length < 0){
////            inBuff = null;
//            if (mPrinterStatusListener != null){
//                mPrinterStatusListener.disconnect(PrinterType.printToUsb, 0);
//            }
//        }
//
//        return inBuff;
    }

    @Override
    public boolean closeDevice() {
//        if (mSelDeivceClass != null){
//            UsbInterface usbInterface = mSelDeivceClass.getUsbInterface();
//            UsbDeviceConnection deviceConnection = mSelDeivceClass.getUsbDeviceConnection();
//
//            deviceConnection.releaseInterface(usbInterface);
//            deviceConnection.close();
//            mIsOpen = false;
//            mUsbInputPoint = null;
//            mUsbOutputPoint = null;
//        }
//
//        return true;

        if (mUsbDev != null){
            mUsbDev.closeDevice();
        }

        mUsbDev = null;
        return true;
    }

    @Override
    public void tryOpenDevice() {

    }

    //    @Override
//    public boolean dinitDevice() {
//        return true;
//    }

    /**
     *  保存选择设备的类型
     */
//    protected class SelDeivceClass{
//
//        /**
//         *  保存USB设备的接口
//         */
//        protected UsbInterface usbInterface;
//
//        /**
//         *  保存所选择的USB设备
//         */
//        protected UsbDevice usbDevice;
//
//        /**
//         *  保存所选择的USB连接对象
//         */
//        protected UsbDeviceConnection usbDeviceConnection;
//
//        public UsbDevice getUsbDevice() {
//            return usbDevice;
//        }
//
//        public void setUsbDevice(UsbDevice usbDevice) {
//            this.usbDevice = usbDevice;
//        }
//
//        public UsbInterface getUsbInterface() {
//            return usbInterface;
//        }
//
//        public void setUsbInterface(UsbInterface usbInterface) {
//            this.usbInterface = usbInterface;
//        }
//
//        public UsbDeviceConnection getUsbDeviceConnection() {
//            return usbDeviceConnection;
//        }
//
//        public void setUsbDeviceConnection(UsbDeviceConnection usbDeviceConnection) {
//            this.usbDeviceConnection = usbDeviceConnection;
//        }
//    }
}
