/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.loader.redis;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.factory.JedisPoolFactory;
import cn.com.fishin.tuz.loader.redis.DefaultRedisConnection;
import cn.com.fishin.tuz.loader.redis.RedisConnection;
import cn.com.fishin.tuz.loader.redis.RedisEntryMap;
import java.io.IOException;
import java.util.Map;
import redis.clients.jedis.JedisPool;

public class RedisLoader
implements Loadable {
    private String namespace = null;
    private Map<String, String> map = null;

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> load() throws IOException {
        return this.map;
    }

    private RedisLoader(String namespace, Map<String, String> map) {
        this.namespace = namespace;
        this.map = map;
    }

    public RedisLoader(String namespace, RedisConnection<String, String> connection) {
        this(namespace, RedisLoader.redisMap(connection));
    }

    public RedisLoader(String namespace, String host, int port, String password, int database) {
        this(namespace, RedisLoader.connection(JedisPoolFactory.defaultPool(host, port, password, database)));
    }

    public RedisLoader(String host, int port, String password, int database) {
        this(RedisLoader.namespace(host, port, database), RedisLoader.connection(JedisPoolFactory.defaultPool(host, port, password, database)));
    }

    public RedisLoader(String host, int port, String password) {
        this(RedisLoader.namespace(host, port), RedisLoader.connection(JedisPoolFactory.defaultPool(host, port, password)));
    }

    public RedisLoader(String host, int port, int database) {
        this(RedisLoader.namespace(host, port, database), RedisLoader.connection(JedisPoolFactory.defaultPool(host, port, database)));
    }

    public RedisLoader(String host, int port) {
        this(RedisLoader.namespace(host, port), RedisLoader.connection(JedisPoolFactory.defaultPool(host, port)));
    }

    private static String namespace(String host, int port, int database) {
        return host + ":" + port + "[" + database + "]";
    }

    private static String namespace(String host, int port) {
        return host + ":" + port;
    }

    private static Map<String, String> redisMap(RedisConnection<String, String> connection) {
        return new RedisEntryMap(connection);
    }

    private static RedisConnection<String, String> connection(JedisPool pool) {
        return new DefaultRedisConnection(pool);
    }
}

